/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.costexplorer.model;

import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.services.costexplorer.model.AttributesCopier;
import software.amazon.awssdk.services.costexplorer.model.ReservationAggregates;
import software.amazon.awssdk.services.costexplorer.transform.ReservationUtilizationGroupMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ReservationUtilizationGroup
implements StructuredPojo,
ToCopyableBuilder<Builder, ReservationUtilizationGroup> {
    private final String key;
    private final String value;
    private final Map<String, String> attributes;
    private final ReservationAggregates utilization;

    private ReservationUtilizationGroup(BuilderImpl builder) {
        this.key = builder.key;
        this.value = builder.value;
        this.attributes = builder.attributes;
        this.utilization = builder.utilization;
    }

    public String key() {
        return this.key;
    }

    public String value() {
        return this.value;
    }

    public Map<String, String> attributes() {
        return this.attributes;
    }

    public ReservationAggregates utilization() {
        return this.utilization;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.key());
        hashCode = 31 * hashCode + Objects.hashCode(this.value());
        hashCode = 31 * hashCode + Objects.hashCode(this.attributes());
        hashCode = 31 * hashCode + Objects.hashCode(this.utilization());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ReservationUtilizationGroup)) {
            return false;
        }
        ReservationUtilizationGroup other = (ReservationUtilizationGroup)obj;
        return Objects.equals(this.key(), other.key()) && Objects.equals(this.value(), other.value()) && Objects.equals(this.attributes(), other.attributes()) && Objects.equals(this.utilization(), other.utilization());
    }

    public String toString() {
        return ToString.builder((String)"ReservationUtilizationGroup").add("Key", (Object)this.key()).add("Value", (Object)this.value()).add("Attributes", this.attributes()).add("Utilization", (Object)this.utilization()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Key": {
                return Optional.ofNullable(clazz.cast(this.key()));
            }
            case "Value": {
                return Optional.ofNullable(clazz.cast(this.value()));
            }
            case "Attributes": {
                return Optional.ofNullable(clazz.cast(this.attributes()));
            }
            case "Utilization": {
                return Optional.ofNullable(clazz.cast(this.utilization()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ReservationUtilizationGroupMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String key;
        private String value;
        private Map<String, String> attributes = DefaultSdkAutoConstructMap.getInstance();
        private ReservationAggregates utilization;

        private BuilderImpl() {
        }

        private BuilderImpl(ReservationUtilizationGroup model) {
            this.key(model.key);
            this.value(model.value);
            this.attributes(model.attributes);
            this.utilization(model.utilization);
        }

        public final String getKey() {
            return this.key;
        }

        @Override
        public final Builder key(String key) {
            this.key = key;
            return this;
        }

        public final void setKey(String key) {
            this.key = key;
        }

        public final String getValue() {
            return this.value;
        }

        @Override
        public final Builder value(String value) {
            this.value = value;
            return this;
        }

        public final void setValue(String value) {
            this.value = value;
        }

        public final Map<String, String> getAttributes() {
            return this.attributes;
        }

        @Override
        public final Builder attributes(Map<String, String> attributes) {
            this.attributes = AttributesCopier.copy(attributes);
            return this;
        }

        public final void setAttributes(Map<String, String> attributes) {
            this.attributes = AttributesCopier.copy(attributes);
        }

        public final ReservationAggregates.Builder getUtilization() {
            return this.utilization != null ? this.utilization.toBuilder() : null;
        }

        @Override
        public final Builder utilization(ReservationAggregates utilization) {
            this.utilization = utilization;
            return this;
        }

        public final void setUtilization(ReservationAggregates.BuilderImpl utilization) {
            this.utilization = utilization != null ? utilization.build() : null;
        }

        public ReservationUtilizationGroup build() {
            return new ReservationUtilizationGroup(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ReservationUtilizationGroup> {
        public Builder key(String var1);

        public Builder value(String var1);

        public Builder attributes(Map<String, String> var1);

        public Builder utilization(ReservationAggregates var1);

        default public Builder utilization(Consumer<ReservationAggregates.Builder> utilization) {
            return this.utilization((ReservationAggregates)((ReservationAggregates.Builder)ReservationAggregates.builder().applyMutation(utilization)).build());
        }
    }
}

