/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.costexplorer.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.costexplorer.transform.ReservationPurchaseRecommendationMetadataMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ReservationPurchaseRecommendationMetadata
implements StructuredPojo,
ToCopyableBuilder<Builder, ReservationPurchaseRecommendationMetadata> {
    private final String recommendationId;
    private final String generationTimestamp;

    private ReservationPurchaseRecommendationMetadata(BuilderImpl builder) {
        this.recommendationId = builder.recommendationId;
        this.generationTimestamp = builder.generationTimestamp;
    }

    public String recommendationId() {
        return this.recommendationId;
    }

    public String generationTimestamp() {
        return this.generationTimestamp;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.recommendationId());
        hashCode = 31 * hashCode + Objects.hashCode(this.generationTimestamp());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ReservationPurchaseRecommendationMetadata)) {
            return false;
        }
        ReservationPurchaseRecommendationMetadata other = (ReservationPurchaseRecommendationMetadata)obj;
        return Objects.equals(this.recommendationId(), other.recommendationId()) && Objects.equals(this.generationTimestamp(), other.generationTimestamp());
    }

    public String toString() {
        return ToString.builder((String)"ReservationPurchaseRecommendationMetadata").add("RecommendationId", (Object)this.recommendationId()).add("GenerationTimestamp", (Object)this.generationTimestamp()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "RecommendationId": {
                return Optional.ofNullable(clazz.cast(this.recommendationId()));
            }
            case "GenerationTimestamp": {
                return Optional.ofNullable(clazz.cast(this.generationTimestamp()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ReservationPurchaseRecommendationMetadataMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String recommendationId;
        private String generationTimestamp;

        private BuilderImpl() {
        }

        private BuilderImpl(ReservationPurchaseRecommendationMetadata model) {
            this.recommendationId(model.recommendationId);
            this.generationTimestamp(model.generationTimestamp);
        }

        public final String getRecommendationId() {
            return this.recommendationId;
        }

        @Override
        public final Builder recommendationId(String recommendationId) {
            this.recommendationId = recommendationId;
            return this;
        }

        public final void setRecommendationId(String recommendationId) {
            this.recommendationId = recommendationId;
        }

        public final String getGenerationTimestamp() {
            return this.generationTimestamp;
        }

        @Override
        public final Builder generationTimestamp(String generationTimestamp) {
            this.generationTimestamp = generationTimestamp;
            return this;
        }

        public final void setGenerationTimestamp(String generationTimestamp) {
            this.generationTimestamp = generationTimestamp;
        }

        public ReservationPurchaseRecommendationMetadata build() {
            return new ReservationPurchaseRecommendationMetadata(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ReservationPurchaseRecommendationMetadata> {
        public Builder recommendationId(String var1);

        public Builder generationTimestamp(String var1);
    }
}

