/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.costexplorer.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.costexplorer.transform.ReservationAggregatesMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ReservationAggregates
implements StructuredPojo,
ToCopyableBuilder<Builder, ReservationAggregates> {
    private final String utilizationPercentage;
    private final String purchasedHours;
    private final String totalActualHours;
    private final String unusedHours;
    private final String onDemandCostOfRIHoursUsed;
    private final String netRISavings;
    private final String totalPotentialRISavings;
    private final String amortizedUpfrontFee;
    private final String amortizedRecurringFee;
    private final String totalAmortizedFee;

    private ReservationAggregates(BuilderImpl builder) {
        this.utilizationPercentage = builder.utilizationPercentage;
        this.purchasedHours = builder.purchasedHours;
        this.totalActualHours = builder.totalActualHours;
        this.unusedHours = builder.unusedHours;
        this.onDemandCostOfRIHoursUsed = builder.onDemandCostOfRIHoursUsed;
        this.netRISavings = builder.netRISavings;
        this.totalPotentialRISavings = builder.totalPotentialRISavings;
        this.amortizedUpfrontFee = builder.amortizedUpfrontFee;
        this.amortizedRecurringFee = builder.amortizedRecurringFee;
        this.totalAmortizedFee = builder.totalAmortizedFee;
    }

    public String utilizationPercentage() {
        return this.utilizationPercentage;
    }

    public String purchasedHours() {
        return this.purchasedHours;
    }

    public String totalActualHours() {
        return this.totalActualHours;
    }

    public String unusedHours() {
        return this.unusedHours;
    }

    public String onDemandCostOfRIHoursUsed() {
        return this.onDemandCostOfRIHoursUsed;
    }

    public String netRISavings() {
        return this.netRISavings;
    }

    public String totalPotentialRISavings() {
        return this.totalPotentialRISavings;
    }

    public String amortizedUpfrontFee() {
        return this.amortizedUpfrontFee;
    }

    public String amortizedRecurringFee() {
        return this.amortizedRecurringFee;
    }

    public String totalAmortizedFee() {
        return this.totalAmortizedFee;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.utilizationPercentage());
        hashCode = 31 * hashCode + Objects.hashCode(this.purchasedHours());
        hashCode = 31 * hashCode + Objects.hashCode(this.totalActualHours());
        hashCode = 31 * hashCode + Objects.hashCode(this.unusedHours());
        hashCode = 31 * hashCode + Objects.hashCode(this.onDemandCostOfRIHoursUsed());
        hashCode = 31 * hashCode + Objects.hashCode(this.netRISavings());
        hashCode = 31 * hashCode + Objects.hashCode(this.totalPotentialRISavings());
        hashCode = 31 * hashCode + Objects.hashCode(this.amortizedUpfrontFee());
        hashCode = 31 * hashCode + Objects.hashCode(this.amortizedRecurringFee());
        hashCode = 31 * hashCode + Objects.hashCode(this.totalAmortizedFee());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ReservationAggregates)) {
            return false;
        }
        ReservationAggregates other = (ReservationAggregates)obj;
        return Objects.equals(this.utilizationPercentage(), other.utilizationPercentage()) && Objects.equals(this.purchasedHours(), other.purchasedHours()) && Objects.equals(this.totalActualHours(), other.totalActualHours()) && Objects.equals(this.unusedHours(), other.unusedHours()) && Objects.equals(this.onDemandCostOfRIHoursUsed(), other.onDemandCostOfRIHoursUsed()) && Objects.equals(this.netRISavings(), other.netRISavings()) && Objects.equals(this.totalPotentialRISavings(), other.totalPotentialRISavings()) && Objects.equals(this.amortizedUpfrontFee(), other.amortizedUpfrontFee()) && Objects.equals(this.amortizedRecurringFee(), other.amortizedRecurringFee()) && Objects.equals(this.totalAmortizedFee(), other.totalAmortizedFee());
    }

    public String toString() {
        return ToString.builder((String)"ReservationAggregates").add("UtilizationPercentage", (Object)this.utilizationPercentage()).add("PurchasedHours", (Object)this.purchasedHours()).add("TotalActualHours", (Object)this.totalActualHours()).add("UnusedHours", (Object)this.unusedHours()).add("OnDemandCostOfRIHoursUsed", (Object)this.onDemandCostOfRIHoursUsed()).add("NetRISavings", (Object)this.netRISavings()).add("TotalPotentialRISavings", (Object)this.totalPotentialRISavings()).add("AmortizedUpfrontFee", (Object)this.amortizedUpfrontFee()).add("AmortizedRecurringFee", (Object)this.amortizedRecurringFee()).add("TotalAmortizedFee", (Object)this.totalAmortizedFee()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "UtilizationPercentage": {
                return Optional.ofNullable(clazz.cast(this.utilizationPercentage()));
            }
            case "PurchasedHours": {
                return Optional.ofNullable(clazz.cast(this.purchasedHours()));
            }
            case "TotalActualHours": {
                return Optional.ofNullable(clazz.cast(this.totalActualHours()));
            }
            case "UnusedHours": {
                return Optional.ofNullable(clazz.cast(this.unusedHours()));
            }
            case "OnDemandCostOfRIHoursUsed": {
                return Optional.ofNullable(clazz.cast(this.onDemandCostOfRIHoursUsed()));
            }
            case "NetRISavings": {
                return Optional.ofNullable(clazz.cast(this.netRISavings()));
            }
            case "TotalPotentialRISavings": {
                return Optional.ofNullable(clazz.cast(this.totalPotentialRISavings()));
            }
            case "AmortizedUpfrontFee": {
                return Optional.ofNullable(clazz.cast(this.amortizedUpfrontFee()));
            }
            case "AmortizedRecurringFee": {
                return Optional.ofNullable(clazz.cast(this.amortizedRecurringFee()));
            }
            case "TotalAmortizedFee": {
                return Optional.ofNullable(clazz.cast(this.totalAmortizedFee()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ReservationAggregatesMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String utilizationPercentage;
        private String purchasedHours;
        private String totalActualHours;
        private String unusedHours;
        private String onDemandCostOfRIHoursUsed;
        private String netRISavings;
        private String totalPotentialRISavings;
        private String amortizedUpfrontFee;
        private String amortizedRecurringFee;
        private String totalAmortizedFee;

        private BuilderImpl() {
        }

        private BuilderImpl(ReservationAggregates model) {
            this.utilizationPercentage(model.utilizationPercentage);
            this.purchasedHours(model.purchasedHours);
            this.totalActualHours(model.totalActualHours);
            this.unusedHours(model.unusedHours);
            this.onDemandCostOfRIHoursUsed(model.onDemandCostOfRIHoursUsed);
            this.netRISavings(model.netRISavings);
            this.totalPotentialRISavings(model.totalPotentialRISavings);
            this.amortizedUpfrontFee(model.amortizedUpfrontFee);
            this.amortizedRecurringFee(model.amortizedRecurringFee);
            this.totalAmortizedFee(model.totalAmortizedFee);
        }

        public final String getUtilizationPercentage() {
            return this.utilizationPercentage;
        }

        @Override
        public final Builder utilizationPercentage(String utilizationPercentage) {
            this.utilizationPercentage = utilizationPercentage;
            return this;
        }

        public final void setUtilizationPercentage(String utilizationPercentage) {
            this.utilizationPercentage = utilizationPercentage;
        }

        public final String getPurchasedHours() {
            return this.purchasedHours;
        }

        @Override
        public final Builder purchasedHours(String purchasedHours) {
            this.purchasedHours = purchasedHours;
            return this;
        }

        public final void setPurchasedHours(String purchasedHours) {
            this.purchasedHours = purchasedHours;
        }

        public final String getTotalActualHours() {
            return this.totalActualHours;
        }

        @Override
        public final Builder totalActualHours(String totalActualHours) {
            this.totalActualHours = totalActualHours;
            return this;
        }

        public final void setTotalActualHours(String totalActualHours) {
            this.totalActualHours = totalActualHours;
        }

        public final String getUnusedHours() {
            return this.unusedHours;
        }

        @Override
        public final Builder unusedHours(String unusedHours) {
            this.unusedHours = unusedHours;
            return this;
        }

        public final void setUnusedHours(String unusedHours) {
            this.unusedHours = unusedHours;
        }

        public final String getOnDemandCostOfRIHoursUsed() {
            return this.onDemandCostOfRIHoursUsed;
        }

        @Override
        public final Builder onDemandCostOfRIHoursUsed(String onDemandCostOfRIHoursUsed) {
            this.onDemandCostOfRIHoursUsed = onDemandCostOfRIHoursUsed;
            return this;
        }

        public final void setOnDemandCostOfRIHoursUsed(String onDemandCostOfRIHoursUsed) {
            this.onDemandCostOfRIHoursUsed = onDemandCostOfRIHoursUsed;
        }

        public final String getNetRISavings() {
            return this.netRISavings;
        }

        @Override
        public final Builder netRISavings(String netRISavings) {
            this.netRISavings = netRISavings;
            return this;
        }

        public final void setNetRISavings(String netRISavings) {
            this.netRISavings = netRISavings;
        }

        public final String getTotalPotentialRISavings() {
            return this.totalPotentialRISavings;
        }

        @Override
        public final Builder totalPotentialRISavings(String totalPotentialRISavings) {
            this.totalPotentialRISavings = totalPotentialRISavings;
            return this;
        }

        public final void setTotalPotentialRISavings(String totalPotentialRISavings) {
            this.totalPotentialRISavings = totalPotentialRISavings;
        }

        public final String getAmortizedUpfrontFee() {
            return this.amortizedUpfrontFee;
        }

        @Override
        public final Builder amortizedUpfrontFee(String amortizedUpfrontFee) {
            this.amortizedUpfrontFee = amortizedUpfrontFee;
            return this;
        }

        public final void setAmortizedUpfrontFee(String amortizedUpfrontFee) {
            this.amortizedUpfrontFee = amortizedUpfrontFee;
        }

        public final String getAmortizedRecurringFee() {
            return this.amortizedRecurringFee;
        }

        @Override
        public final Builder amortizedRecurringFee(String amortizedRecurringFee) {
            this.amortizedRecurringFee = amortizedRecurringFee;
            return this;
        }

        public final void setAmortizedRecurringFee(String amortizedRecurringFee) {
            this.amortizedRecurringFee = amortizedRecurringFee;
        }

        public final String getTotalAmortizedFee() {
            return this.totalAmortizedFee;
        }

        @Override
        public final Builder totalAmortizedFee(String totalAmortizedFee) {
            this.totalAmortizedFee = totalAmortizedFee;
            return this;
        }

        public final void setTotalAmortizedFee(String totalAmortizedFee) {
            this.totalAmortizedFee = totalAmortizedFee;
        }

        public ReservationAggregates build() {
            return new ReservationAggregates(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ReservationAggregates> {
        public Builder utilizationPercentage(String var1);

        public Builder purchasedHours(String var1);

        public Builder totalActualHours(String var1);

        public Builder unusedHours(String var1);

        public Builder onDemandCostOfRIHoursUsed(String var1);

        public Builder netRISavings(String var1);

        public Builder totalPotentialRISavings(String var1);

        public Builder amortizedUpfrontFee(String var1);

        public Builder amortizedRecurringFee(String var1);

        public Builder totalAmortizedFee(String var1);
    }
}

