/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.costexplorer.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.services.costexplorer.model.CostExplorerRequest;
import software.amazon.awssdk.services.costexplorer.model.DateInterval;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetTagsRequest
extends CostExplorerRequest
implements ToCopyableBuilder<Builder, GetTagsRequest> {
    private final String searchString;
    private final DateInterval timePeriod;
    private final String tagKey;
    private final String nextPageToken;

    private GetTagsRequest(BuilderImpl builder) {
        super(builder);
        this.searchString = builder.searchString;
        this.timePeriod = builder.timePeriod;
        this.tagKey = builder.tagKey;
        this.nextPageToken = builder.nextPageToken;
    }

    public String searchString() {
        return this.searchString;
    }

    public DateInterval timePeriod() {
        return this.timePeriod;
    }

    public String tagKey() {
        return this.tagKey;
    }

    public String nextPageToken() {
        return this.nextPageToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.searchString());
        hashCode = 31 * hashCode + Objects.hashCode(this.timePeriod());
        hashCode = 31 * hashCode + Objects.hashCode(this.tagKey());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextPageToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetTagsRequest)) {
            return false;
        }
        GetTagsRequest other = (GetTagsRequest)((Object)obj);
        return Objects.equals(this.searchString(), other.searchString()) && Objects.equals(this.timePeriod(), other.timePeriod()) && Objects.equals(this.tagKey(), other.tagKey()) && Objects.equals(this.nextPageToken(), other.nextPageToken());
    }

    public String toString() {
        return ToString.builder((String)"GetTagsRequest").add("SearchString", (Object)this.searchString()).add("TimePeriod", (Object)this.timePeriod()).add("TagKey", (Object)this.tagKey()).add("NextPageToken", (Object)this.nextPageToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "SearchString": {
                return Optional.ofNullable(clazz.cast(this.searchString()));
            }
            case "TimePeriod": {
                return Optional.ofNullable(clazz.cast(this.timePeriod()));
            }
            case "TagKey": {
                return Optional.ofNullable(clazz.cast(this.tagKey()));
            }
            case "NextPageToken": {
                return Optional.ofNullable(clazz.cast(this.nextPageToken()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends CostExplorerRequest.BuilderImpl
    implements Builder {
        private String searchString;
        private DateInterval timePeriod;
        private String tagKey;
        private String nextPageToken;

        private BuilderImpl() {
        }

        private BuilderImpl(GetTagsRequest model) {
            super(model);
            this.searchString(model.searchString);
            this.timePeriod(model.timePeriod);
            this.tagKey(model.tagKey);
            this.nextPageToken(model.nextPageToken);
        }

        public final String getSearchString() {
            return this.searchString;
        }

        @Override
        public final Builder searchString(String searchString) {
            this.searchString = searchString;
            return this;
        }

        public final void setSearchString(String searchString) {
            this.searchString = searchString;
        }

        public final DateInterval.Builder getTimePeriod() {
            return this.timePeriod != null ? this.timePeriod.toBuilder() : null;
        }

        @Override
        public final Builder timePeriod(DateInterval timePeriod) {
            this.timePeriod = timePeriod;
            return this;
        }

        public final void setTimePeriod(DateInterval.BuilderImpl timePeriod) {
            this.timePeriod = timePeriod != null ? timePeriod.build() : null;
        }

        public final String getTagKey() {
            return this.tagKey;
        }

        @Override
        public final Builder tagKey(String tagKey) {
            this.tagKey = tagKey;
            return this;
        }

        public final void setTagKey(String tagKey) {
            this.tagKey = tagKey;
        }

        public final String getNextPageToken() {
            return this.nextPageToken;
        }

        @Override
        public final Builder nextPageToken(String nextPageToken) {
            this.nextPageToken = nextPageToken;
            return this;
        }

        public final void setNextPageToken(String nextPageToken) {
            this.nextPageToken = nextPageToken;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetTagsRequest build() {
            return new GetTagsRequest(this);
        }
    }

    public static interface Builder
    extends CostExplorerRequest.Builder,
    CopyableBuilder<Builder, GetTagsRequest> {
        public Builder searchString(String var1);

        public Builder timePeriod(DateInterval var1);

        default public Builder timePeriod(Consumer<DateInterval.Builder> timePeriod) {
            return this.timePeriod((DateInterval)((DateInterval.Builder)DateInterval.builder().applyMutation(timePeriod)).build());
        }

        public Builder tagKey(String var1);

        public Builder nextPageToken(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

