/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.costexplorer.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.costexplorer.transform.ESInstanceDetailsMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ESInstanceDetails
implements StructuredPojo,
ToCopyableBuilder<Builder, ESInstanceDetails> {
    private final String instanceClass;
    private final String instanceSize;
    private final String region;
    private final Boolean currentGeneration;
    private final Boolean sizeFlexEligible;

    private ESInstanceDetails(BuilderImpl builder) {
        this.instanceClass = builder.instanceClass;
        this.instanceSize = builder.instanceSize;
        this.region = builder.region;
        this.currentGeneration = builder.currentGeneration;
        this.sizeFlexEligible = builder.sizeFlexEligible;
    }

    public String instanceClass() {
        return this.instanceClass;
    }

    public String instanceSize() {
        return this.instanceSize;
    }

    public String region() {
        return this.region;
    }

    public Boolean currentGeneration() {
        return this.currentGeneration;
    }

    public Boolean sizeFlexEligible() {
        return this.sizeFlexEligible;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceClass());
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceSize());
        hashCode = 31 * hashCode + Objects.hashCode(this.region());
        hashCode = 31 * hashCode + Objects.hashCode(this.currentGeneration());
        hashCode = 31 * hashCode + Objects.hashCode(this.sizeFlexEligible());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ESInstanceDetails)) {
            return false;
        }
        ESInstanceDetails other = (ESInstanceDetails)obj;
        return Objects.equals(this.instanceClass(), other.instanceClass()) && Objects.equals(this.instanceSize(), other.instanceSize()) && Objects.equals(this.region(), other.region()) && Objects.equals(this.currentGeneration(), other.currentGeneration()) && Objects.equals(this.sizeFlexEligible(), other.sizeFlexEligible());
    }

    public String toString() {
        return ToString.builder((String)"ESInstanceDetails").add("InstanceClass", (Object)this.instanceClass()).add("InstanceSize", (Object)this.instanceSize()).add("Region", (Object)this.region()).add("CurrentGeneration", (Object)this.currentGeneration()).add("SizeFlexEligible", (Object)this.sizeFlexEligible()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "InstanceClass": {
                return Optional.ofNullable(clazz.cast(this.instanceClass()));
            }
            case "InstanceSize": {
                return Optional.ofNullable(clazz.cast(this.instanceSize()));
            }
            case "Region": {
                return Optional.ofNullable(clazz.cast(this.region()));
            }
            case "CurrentGeneration": {
                return Optional.ofNullable(clazz.cast(this.currentGeneration()));
            }
            case "SizeFlexEligible": {
                return Optional.ofNullable(clazz.cast(this.sizeFlexEligible()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ESInstanceDetailsMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String instanceClass;
        private String instanceSize;
        private String region;
        private Boolean currentGeneration;
        private Boolean sizeFlexEligible;

        private BuilderImpl() {
        }

        private BuilderImpl(ESInstanceDetails model) {
            this.instanceClass(model.instanceClass);
            this.instanceSize(model.instanceSize);
            this.region(model.region);
            this.currentGeneration(model.currentGeneration);
            this.sizeFlexEligible(model.sizeFlexEligible);
        }

        public final String getInstanceClass() {
            return this.instanceClass;
        }

        @Override
        public final Builder instanceClass(String instanceClass) {
            this.instanceClass = instanceClass;
            return this;
        }

        public final void setInstanceClass(String instanceClass) {
            this.instanceClass = instanceClass;
        }

        public final String getInstanceSize() {
            return this.instanceSize;
        }

        @Override
        public final Builder instanceSize(String instanceSize) {
            this.instanceSize = instanceSize;
            return this;
        }

        public final void setInstanceSize(String instanceSize) {
            this.instanceSize = instanceSize;
        }

        public final String getRegion() {
            return this.region;
        }

        @Override
        public final Builder region(String region) {
            this.region = region;
            return this;
        }

        public final void setRegion(String region) {
            this.region = region;
        }

        public final Boolean getCurrentGeneration() {
            return this.currentGeneration;
        }

        @Override
        public final Builder currentGeneration(Boolean currentGeneration) {
            this.currentGeneration = currentGeneration;
            return this;
        }

        public final void setCurrentGeneration(Boolean currentGeneration) {
            this.currentGeneration = currentGeneration;
        }

        public final Boolean getSizeFlexEligible() {
            return this.sizeFlexEligible;
        }

        @Override
        public final Builder sizeFlexEligible(Boolean sizeFlexEligible) {
            this.sizeFlexEligible = sizeFlexEligible;
            return this;
        }

        public final void setSizeFlexEligible(Boolean sizeFlexEligible) {
            this.sizeFlexEligible = sizeFlexEligible;
        }

        public ESInstanceDetails build() {
            return new ESInstanceDetails(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ESInstanceDetails> {
        public Builder instanceClass(String var1);

        public Builder instanceSize(String var1);

        public Builder region(String var1);

        public Builder currentGeneration(Boolean var1);

        public Builder sizeFlexEligible(Boolean var1);
    }
}

