/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.costexplorer.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.costexplorer.model.OfferingClass;
import software.amazon.awssdk.services.costexplorer.transform.EC2SpecificationMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class EC2Specification
implements StructuredPojo,
ToCopyableBuilder<Builder, EC2Specification> {
    private final String offeringClass;

    private EC2Specification(BuilderImpl builder) {
        this.offeringClass = builder.offeringClass;
    }

    public OfferingClass offeringClass() {
        return OfferingClass.fromValue(this.offeringClass);
    }

    public String offeringClassAsString() {
        return this.offeringClass;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.offeringClassAsString());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EC2Specification)) {
            return false;
        }
        EC2Specification other = (EC2Specification)obj;
        return Objects.equals(this.offeringClassAsString(), other.offeringClassAsString());
    }

    public String toString() {
        return ToString.builder((String)"EC2Specification").add("OfferingClass", (Object)this.offeringClassAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "OfferingClass": {
                return Optional.ofNullable(clazz.cast(this.offeringClassAsString()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        EC2SpecificationMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String offeringClass;

        private BuilderImpl() {
        }

        private BuilderImpl(EC2Specification model) {
            this.offeringClass(model.offeringClass);
        }

        public final String getOfferingClass() {
            return this.offeringClass;
        }

        @Override
        public final Builder offeringClass(String offeringClass) {
            this.offeringClass = offeringClass;
            return this;
        }

        @Override
        public final Builder offeringClass(OfferingClass offeringClass) {
            this.offeringClass(offeringClass.toString());
            return this;
        }

        public final void setOfferingClass(String offeringClass) {
            this.offeringClass = offeringClass;
        }

        public EC2Specification build() {
            return new EC2Specification(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, EC2Specification> {
        public Builder offeringClass(String var1);

        public Builder offeringClass(OfferingClass var1);
    }
}

