/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.costexplorer.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum Dimension {
    AZ("AZ"),
    INSTANCE_TYPE("INSTANCE_TYPE"),
    LINKED_ACCOUNT("LINKED_ACCOUNT"),
    OPERATION("OPERATION"),
    PURCHASE_TYPE("PURCHASE_TYPE"),
    REGION("REGION"),
    SERVICE("SERVICE"),
    USAGE_TYPE("USAGE_TYPE"),
    USAGE_TYPE_GROUP("USAGE_TYPE_GROUP"),
    RECORD_TYPE("RECORD_TYPE"),
    OPERATING_SYSTEM("OPERATING_SYSTEM"),
    TENANCY("TENANCY"),
    SCOPE("SCOPE"),
    PLATFORM("PLATFORM"),
    SUBSCRIPTION_ID("SUBSCRIPTION_ID"),
    LEGAL_ENTITY_NAME("LEGAL_ENTITY_NAME"),
    DEPLOYMENT_OPTION("DEPLOYMENT_OPTION"),
    DATABASE_ENGINE("DATABASE_ENGINE"),
    CACHE_ENGINE("CACHE_ENGINE"),
    INSTANCE_TYPE_FAMILY("INSTANCE_TYPE_FAMILY"),
    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private Dimension(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static Dimension fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(Dimension.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<Dimension> knownValues() {
        return Stream.of(Dimension.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}

