/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.costexplorer;

import java.util.concurrent.CompletableFuture;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.handler.AwsAsyncClientHandler;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.awscore.internal.protocol.json.AwsJsonProtocol;
import software.amazon.awssdk.awscore.protocol.json.AwsJsonProtocolFactory;
import software.amazon.awssdk.awscore.protocol.json.AwsJsonProtocolMetadata;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.client.handler.AsyncClientHandler;
import software.amazon.awssdk.core.client.handler.ClientExecutionParams;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.http.JsonResponseHandler;
import software.amazon.awssdk.core.internal.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.protocol.json.JsonClientMetadata;
import software.amazon.awssdk.core.protocol.json.JsonErrorResponseMetadata;
import software.amazon.awssdk.core.protocol.json.JsonErrorShapeMetadata;
import software.amazon.awssdk.core.protocol.json.JsonOperationMetadata;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.costexplorer.CostExplorerAsyncClient;
import software.amazon.awssdk.services.costexplorer.model.BillExpirationException;
import software.amazon.awssdk.services.costexplorer.model.CostExplorerException;
import software.amazon.awssdk.services.costexplorer.model.DataUnavailableException;
import software.amazon.awssdk.services.costexplorer.model.GetCostAndUsageRequest;
import software.amazon.awssdk.services.costexplorer.model.GetCostAndUsageResponse;
import software.amazon.awssdk.services.costexplorer.model.GetDimensionValuesRequest;
import software.amazon.awssdk.services.costexplorer.model.GetDimensionValuesResponse;
import software.amazon.awssdk.services.costexplorer.model.GetReservationCoverageRequest;
import software.amazon.awssdk.services.costexplorer.model.GetReservationCoverageResponse;
import software.amazon.awssdk.services.costexplorer.model.GetReservationPurchaseRecommendationRequest;
import software.amazon.awssdk.services.costexplorer.model.GetReservationPurchaseRecommendationResponse;
import software.amazon.awssdk.services.costexplorer.model.GetReservationUtilizationRequest;
import software.amazon.awssdk.services.costexplorer.model.GetReservationUtilizationResponse;
import software.amazon.awssdk.services.costexplorer.model.GetTagsRequest;
import software.amazon.awssdk.services.costexplorer.model.GetTagsResponse;
import software.amazon.awssdk.services.costexplorer.model.InvalidNextTokenException;
import software.amazon.awssdk.services.costexplorer.model.LimitExceededException;
import software.amazon.awssdk.services.costexplorer.model.RequestChangedException;
import software.amazon.awssdk.services.costexplorer.transform.GetCostAndUsageRequestMarshaller;
import software.amazon.awssdk.services.costexplorer.transform.GetCostAndUsageResponseUnmarshaller;
import software.amazon.awssdk.services.costexplorer.transform.GetDimensionValuesRequestMarshaller;
import software.amazon.awssdk.services.costexplorer.transform.GetDimensionValuesResponseUnmarshaller;
import software.amazon.awssdk.services.costexplorer.transform.GetReservationCoverageRequestMarshaller;
import software.amazon.awssdk.services.costexplorer.transform.GetReservationCoverageResponseUnmarshaller;
import software.amazon.awssdk.services.costexplorer.transform.GetReservationPurchaseRecommendationRequestMarshaller;
import software.amazon.awssdk.services.costexplorer.transform.GetReservationPurchaseRecommendationResponseUnmarshaller;
import software.amazon.awssdk.services.costexplorer.transform.GetReservationUtilizationRequestMarshaller;
import software.amazon.awssdk.services.costexplorer.transform.GetReservationUtilizationResponseUnmarshaller;
import software.amazon.awssdk.services.costexplorer.transform.GetTagsRequestMarshaller;
import software.amazon.awssdk.services.costexplorer.transform.GetTagsResponseUnmarshaller;
import software.amazon.awssdk.utils.CompletableFutureUtils;

@SdkInternalApi
final class DefaultCostExplorerAsyncClient
implements CostExplorerAsyncClient {
    private static final Logger log = LoggerFactory.getLogger(DefaultCostExplorerAsyncClient.class);
    private final AsyncClientHandler clientHandler;
    private final AwsJsonProtocolFactory protocolFactory;

    protected DefaultCostExplorerAsyncClient(SdkClientConfiguration clientConfiguration) {
        this.clientHandler = new AwsAsyncClientHandler(clientConfiguration);
        this.protocolFactory = this.init(false);
    }

    public final String serviceName() {
        return "ce";
    }

    @Override
    public CompletableFuture<GetCostAndUsageResponse> getCostAndUsage(GetCostAndUsageRequest getCostAndUsageRequest) {
        try {
            JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new GetCostAndUsageResponseUnmarshaller());
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory);
            return this.clientHandler.execute(new ClientExecutionParams().withMarshaller((Marshaller)new GetCostAndUsageRequestMarshaller(this.protocolFactory)).withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getCostAndUsageRequest));
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetDimensionValuesResponse> getDimensionValues(GetDimensionValuesRequest getDimensionValuesRequest) {
        try {
            JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new GetDimensionValuesResponseUnmarshaller());
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory);
            return this.clientHandler.execute(new ClientExecutionParams().withMarshaller((Marshaller)new GetDimensionValuesRequestMarshaller(this.protocolFactory)).withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getDimensionValuesRequest));
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetReservationCoverageResponse> getReservationCoverage(GetReservationCoverageRequest getReservationCoverageRequest) {
        try {
            JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new GetReservationCoverageResponseUnmarshaller());
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory);
            return this.clientHandler.execute(new ClientExecutionParams().withMarshaller((Marshaller)new GetReservationCoverageRequestMarshaller(this.protocolFactory)).withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getReservationCoverageRequest));
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetReservationPurchaseRecommendationResponse> getReservationPurchaseRecommendation(GetReservationPurchaseRecommendationRequest getReservationPurchaseRecommendationRequest) {
        try {
            JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new GetReservationPurchaseRecommendationResponseUnmarshaller());
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory);
            return this.clientHandler.execute(new ClientExecutionParams().withMarshaller((Marshaller)new GetReservationPurchaseRecommendationRequestMarshaller(this.protocolFactory)).withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getReservationPurchaseRecommendationRequest));
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetReservationUtilizationResponse> getReservationUtilization(GetReservationUtilizationRequest getReservationUtilizationRequest) {
        try {
            JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new GetReservationUtilizationResponseUnmarshaller());
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory);
            return this.clientHandler.execute(new ClientExecutionParams().withMarshaller((Marshaller)new GetReservationUtilizationRequestMarshaller(this.protocolFactory)).withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getReservationUtilizationRequest));
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetTagsResponse> getTags(GetTagsRequest getTagsRequest) {
        try {
            JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new GetTagsResponseUnmarshaller());
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory);
            return this.clientHandler.execute(new ClientExecutionParams().withMarshaller((Marshaller)new GetTagsRequestMarshaller(this.protocolFactory)).withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getTagsRequest));
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    public void close() {
        this.clientHandler.close();
    }

    private AwsJsonProtocolFactory init(boolean supportsCbor) {
        return new AwsJsonProtocolFactory(new JsonClientMetadata().withSupportsCbor(supportsCbor).withSupportsIon(false).withBaseServiceExceptionClass(CostExplorerException.class).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("RequestChangedException").withModeledClass(RequestChangedException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("DataUnavailableException").withModeledClass(DataUnavailableException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("BillExpirationException").withModeledClass(BillExpirationException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("InvalidNextTokenException").withModeledClass(InvalidNextTokenException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("LimitExceededException").withModeledClass(LimitExceededException.class)), AwsJsonProtocolMetadata.builder().protocolVersion("1.1").protocol(AwsJsonProtocol.AWS_JSON).build());
    }

    private HttpResponseHandler<AwsServiceException> createErrorResponseHandler(AwsJsonProtocolFactory protocolFactory) {
        return protocolFactory.createErrorResponseHandler(new JsonErrorResponseMetadata());
    }
}

