/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.costandusagereport.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum CompressionFormat {
    ZIP("ZIP"),
    GZIP("GZIP"),
    PARQUET("Parquet"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, CompressionFormat> VALUE_MAP;
    private final String value;

    private CompressionFormat(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static CompressionFormat fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<CompressionFormat> knownValues() {
        EnumSet<CompressionFormat> knownValues = EnumSet.allOf(CompressionFormat.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(CompressionFormat.class, CompressionFormat::toString);
    }
}

