/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.costandusagereport.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Creates a Cost and Usage Report.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class PutReportDefinitionRequest extends CostAndUsageReportRequest implements
        ToCopyableBuilder<PutReportDefinitionRequest.Builder, PutReportDefinitionRequest> {
    private static final SdkField<ReportDefinition> REPORT_DEFINITION_FIELD = SdkField
            .<ReportDefinition> builder(MarshallingType.SDK_POJO).getter(getter(PutReportDefinitionRequest::reportDefinition))
            .setter(setter(Builder::reportDefinition)).constructor(ReportDefinition::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReportDefinition").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REPORT_DEFINITION_FIELD));

    private final ReportDefinition reportDefinition;

    private PutReportDefinitionRequest(BuilderImpl builder) {
        super(builder);
        this.reportDefinition = builder.reportDefinition;
    }

    /**
     * <p>
     * Represents the output of the PutReportDefinition operation. The content consists of the detailed metadata and
     * data file information.
     * </p>
     * 
     * @return Represents the output of the PutReportDefinition operation. The content consists of the detailed metadata
     *         and data file information.
     */
    public ReportDefinition reportDefinition() {
        return reportDefinition;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(reportDefinition());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutReportDefinitionRequest)) {
            return false;
        }
        PutReportDefinitionRequest other = (PutReportDefinitionRequest) obj;
        return Objects.equals(reportDefinition(), other.reportDefinition());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("PutReportDefinitionRequest").add("ReportDefinition", reportDefinition()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ReportDefinition":
            return Optional.ofNullable(clazz.cast(reportDefinition()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PutReportDefinitionRequest, T> g) {
        return obj -> g.apply((PutReportDefinitionRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CostAndUsageReportRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, PutReportDefinitionRequest> {
        /**
         * <p>
         * Represents the output of the PutReportDefinition operation. The content consists of the detailed metadata and
         * data file information.
         * </p>
         * 
         * @param reportDefinition
         *        Represents the output of the PutReportDefinition operation. The content consists of the detailed
         *        metadata and data file information.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder reportDefinition(ReportDefinition reportDefinition);

        /**
         * <p>
         * Represents the output of the PutReportDefinition operation. The content consists of the detailed metadata and
         * data file information.
         * </p>
         * This is a convenience that creates an instance of the {@link ReportDefinition.Builder} avoiding the need to
         * create one manually via {@link ReportDefinition#builder()}.
         *
         * When the {@link Consumer} completes, {@link ReportDefinition.Builder#build()} is called immediately and its
         * result is passed to {@link #reportDefinition(ReportDefinition)}.
         * 
         * @param reportDefinition
         *        a consumer that will call methods on {@link ReportDefinition.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #reportDefinition(ReportDefinition)
         */
        default Builder reportDefinition(Consumer<ReportDefinition.Builder> reportDefinition) {
            return reportDefinition(ReportDefinition.builder().applyMutation(reportDefinition).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends CostAndUsageReportRequest.BuilderImpl implements Builder {
        private ReportDefinition reportDefinition;

        private BuilderImpl() {
        }

        private BuilderImpl(PutReportDefinitionRequest model) {
            super(model);
            reportDefinition(model.reportDefinition);
        }

        public final ReportDefinition.Builder getReportDefinition() {
            return reportDefinition != null ? reportDefinition.toBuilder() : null;
        }

        @Override
        public final Builder reportDefinition(ReportDefinition reportDefinition) {
            this.reportDefinition = reportDefinition;
            return this;
        }

        public final void setReportDefinition(ReportDefinition.BuilderImpl reportDefinition) {
            this.reportDefinition = reportDefinition != null ? reportDefinition.build() : null;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public PutReportDefinitionRequest build() {
            return new PutReportDefinitionRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
