/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.costandusagereport.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.NextPageFetcher;
import software.amazon.awssdk.core.pagination.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.SdkIterable;
import software.amazon.awssdk.services.costandusagereport.CostandUsageReportClient;
import software.amazon.awssdk.services.costandusagereport.model.DescribeReportDefinitionsRequest;
import software.amazon.awssdk.services.costandusagereport.model.DescribeReportDefinitionsResponse;

public final class DescribeReportDefinitionsPaginator
implements SdkIterable<DescribeReportDefinitionsResponse> {
    private final CostandUsageReportClient client;
    private final DescribeReportDefinitionsRequest firstRequest;
    private final NextPageFetcher nextPageFetcher;

    public DescribeReportDefinitionsPaginator(CostandUsageReportClient client, DescribeReportDefinitionsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new DescribeReportDefinitionsResponseFetcher();
    }

    public Iterator<DescribeReportDefinitionsResponse> iterator() {
        return new PaginatedResponsesIterator(this.nextPageFetcher);
    }

    private class DescribeReportDefinitionsResponseFetcher
    implements NextPageFetcher<DescribeReportDefinitionsResponse> {
        private DescribeReportDefinitionsResponseFetcher() {
        }

        public boolean hasNextPage(DescribeReportDefinitionsResponse previousPage) {
            return previousPage.nextToken() != null;
        }

        public DescribeReportDefinitionsResponse nextPage(DescribeReportDefinitionsResponse previousPage) {
            if (previousPage == null) {
                return DescribeReportDefinitionsPaginator.this.client.describeReportDefinitions(DescribeReportDefinitionsPaginator.this.firstRequest);
            }
            return DescribeReportDefinitionsPaginator.this.client.describeReportDefinitions((DescribeReportDefinitionsRequest)((Object)DescribeReportDefinitionsPaginator.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

