/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.costandusagereport;

import java.util.concurrent.CompletableFuture;
import software.amazon.awssdk.AmazonServiceException;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.client.AsyncClientHandler;
import software.amazon.awssdk.client.AwsAsyncClientParams;
import software.amazon.awssdk.client.AwsSyncClientParams;
import software.amazon.awssdk.client.ClientExecutionParams;
import software.amazon.awssdk.client.ClientHandlerParams;
import software.amazon.awssdk.client.SdkAsyncClientHandler;
import software.amazon.awssdk.http.HttpResponseHandler;
import software.amazon.awssdk.protocol.json.JsonClientMetadata;
import software.amazon.awssdk.protocol.json.JsonErrorResponseMetadata;
import software.amazon.awssdk.protocol.json.JsonErrorShapeMetadata;
import software.amazon.awssdk.protocol.json.JsonOperationMetadata;
import software.amazon.awssdk.protocol.json.SdkJsonProtocolFactory;
import software.amazon.awssdk.runtime.http.response.JsonResponseHandler;
import software.amazon.awssdk.runtime.transform.Marshaller;
import software.amazon.awssdk.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.costandusagereport.CostandUsageReportAsyncClient;
import software.amazon.awssdk.services.costandusagereport.model.CostandUsageReportException;
import software.amazon.awssdk.services.costandusagereport.model.DeleteReportDefinitionRequest;
import software.amazon.awssdk.services.costandusagereport.model.DeleteReportDefinitionResponse;
import software.amazon.awssdk.services.costandusagereport.model.DescribeReportDefinitionsRequest;
import software.amazon.awssdk.services.costandusagereport.model.DescribeReportDefinitionsResponse;
import software.amazon.awssdk.services.costandusagereport.model.DuplicateReportNameException;
import software.amazon.awssdk.services.costandusagereport.model.InternalErrorException;
import software.amazon.awssdk.services.costandusagereport.model.PutReportDefinitionRequest;
import software.amazon.awssdk.services.costandusagereport.model.PutReportDefinitionResponse;
import software.amazon.awssdk.services.costandusagereport.model.ReportLimitReachedException;
import software.amazon.awssdk.services.costandusagereport.model.ValidationException;
import software.amazon.awssdk.services.costandusagereport.transform.DeleteReportDefinitionRequestMarshaller;
import software.amazon.awssdk.services.costandusagereport.transform.DeleteReportDefinitionResponseUnmarshaller;
import software.amazon.awssdk.services.costandusagereport.transform.DescribeReportDefinitionsRequestMarshaller;
import software.amazon.awssdk.services.costandusagereport.transform.DescribeReportDefinitionsResponseUnmarshaller;
import software.amazon.awssdk.services.costandusagereport.transform.PutReportDefinitionRequestMarshaller;
import software.amazon.awssdk.services.costandusagereport.transform.PutReportDefinitionResponseUnmarshaller;

@SdkInternalApi
final class DefaultCostandUsageReportAsyncClient
implements CostandUsageReportAsyncClient {
    private final AsyncClientHandler clientHandler;
    private final SdkJsonProtocolFactory protocolFactory;

    protected DefaultCostandUsageReportAsyncClient(AwsAsyncClientParams clientParams) {
        this.clientHandler = new SdkAsyncClientHandler(new ClientHandlerParams().withAsyncClientParams(clientParams).withClientParams((AwsSyncClientParams)clientParams).withCalculateCrc32FromCompressedDataEnabled(false));
        this.protocolFactory = this.init();
    }

    @Override
    public CompletableFuture<DeleteReportDefinitionResponse> deleteReportDefinition(DeleteReportDefinitionRequest deleteReportDefinitionRequest) {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true), (Unmarshaller)new DeleteReportDefinitionResponseUnmarshaller());
        HttpResponseHandler<AmazonServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return this.clientHandler.execute(new ClientExecutionParams().withMarshaller((Marshaller)new DeleteReportDefinitionRequestMarshaller(this.protocolFactory)).withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((Object)deleteReportDefinitionRequest));
    }

    @Override
    public CompletableFuture<DescribeReportDefinitionsResponse> describeReportDefinitions() {
        return this.describeReportDefinitions((DescribeReportDefinitionsRequest)((Object)DescribeReportDefinitionsRequest.builder().build()));
    }

    @Override
    public CompletableFuture<DescribeReportDefinitionsResponse> describeReportDefinitions(DescribeReportDefinitionsRequest describeReportDefinitionsRequest) {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true), (Unmarshaller)new DescribeReportDefinitionsResponseUnmarshaller());
        HttpResponseHandler<AmazonServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return this.clientHandler.execute(new ClientExecutionParams().withMarshaller((Marshaller)new DescribeReportDefinitionsRequestMarshaller(this.protocolFactory)).withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((Object)describeReportDefinitionsRequest));
    }

    @Override
    public CompletableFuture<PutReportDefinitionResponse> putReportDefinition(PutReportDefinitionRequest putReportDefinitionRequest) {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true), (Unmarshaller)new PutReportDefinitionResponseUnmarshaller());
        HttpResponseHandler<AmazonServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return this.clientHandler.execute(new ClientExecutionParams().withMarshaller((Marshaller)new PutReportDefinitionRequestMarshaller(this.protocolFactory)).withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((Object)putReportDefinitionRequest));
    }

    @Override
    public void close() throws Exception {
        this.clientHandler.close();
    }

    private SdkJsonProtocolFactory init() {
        return new SdkJsonProtocolFactory(new JsonClientMetadata().withProtocolVersion("1.1").withSupportsCbor(false).withSupportsIon(false).withBaseServiceExceptionClass(CostandUsageReportException.class).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ValidationException").withModeledClass(ValidationException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ReportLimitReachedException").withModeledClass(ReportLimitReachedException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("InternalErrorException").withModeledClass(InternalErrorException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("DuplicateReportNameException").withModeledClass(DuplicateReportNameException.class)));
    }

    private HttpResponseHandler<AmazonServiceException> createErrorResponseHandler() {
        return this.protocolFactory.createErrorResponseHandler(new JsonErrorResponseMetadata());
    }
}

