/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.costandusagereport.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.EmptySubscription;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.pagination.async.SdkPublisher;
import software.amazon.awssdk.services.costandusagereport.CostandUsageReportAsyncClient;
import software.amazon.awssdk.services.costandusagereport.model.DescribeReportDefinitionsRequest;
import software.amazon.awssdk.services.costandusagereport.model.DescribeReportDefinitionsResponse;

public class DescribeReportDefinitionsPublisher
implements SdkPublisher<DescribeReportDefinitionsResponse> {
    private final CostandUsageReportAsyncClient client;
    private final DescribeReportDefinitionsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public DescribeReportDefinitionsPublisher(CostandUsageReportAsyncClient client, DescribeReportDefinitionsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private DescribeReportDefinitionsPublisher(CostandUsageReportAsyncClient client, DescribeReportDefinitionsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new DescribeReportDefinitionsResponseFetcher();
    }

    public void subscribe(Subscriber<? super DescribeReportDefinitionsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)new ResponsesSubscription(subscriber, this.nextPageFetcher));
    }

    public final DescribeReportDefinitionsPublisher resume(DescribeReportDefinitionsResponse lastSuccessfulPage) {
        if (this.nextPageFetcher.hasNextPage((Object)lastSuccessfulPage)) {
            return new DescribeReportDefinitionsPublisher(this.client, (DescribeReportDefinitionsRequest)((Object)this.firstRequest.toBuilder().nextToken(lastSuccessfulPage.nextToken()).build()));
        }
        return new DescribeReportDefinitionsPublisher(this.client, this.firstRequest, true){

            @Override
            public void subscribe(Subscriber<? super DescribeReportDefinitionsResponse> subscriber) {
                subscriber.onSubscribe((Subscription)new EmptySubscription(subscriber));
            }
        };
    }

    private class DescribeReportDefinitionsResponseFetcher
    implements AsyncPageFetcher<DescribeReportDefinitionsResponse> {
        private DescribeReportDefinitionsResponseFetcher() {
        }

        public boolean hasNextPage(DescribeReportDefinitionsResponse previousPage) {
            return previousPage.nextToken() != null;
        }

        public CompletableFuture<DescribeReportDefinitionsResponse> nextPage(DescribeReportDefinitionsResponse previousPage) {
            if (previousPage == null) {
                return DescribeReportDefinitionsPublisher.this.client.describeReportDefinitions(DescribeReportDefinitionsPublisher.this.firstRequest);
            }
            return DescribeReportDefinitionsPublisher.this.client.describeReportDefinitions((DescribeReportDefinitionsRequest)((Object)DescribeReportDefinitionsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

