/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.util;

import org.slf4j.LoggerFactory;
import software.amazon.awssdk.AbortedException;
import software.amazon.awssdk.AmazonClientException;

public enum Throwables {


    public static Throwable getRootCause(Throwable orig) {
        if (orig == null) {
            return orig;
        }
        Throwable t = orig;
        for (int i = 0; i < 1000; ++i) {
            Throwable cause = t.getCause();
            if (cause == null) {
                return t;
            }
            t = cause;
        }
        LoggerFactory.getLogger(Throwables.class).debug("Possible circular reference detected on " + orig.getClass() + ": [" + orig + "]");
        return orig;
    }

    public static RuntimeException failure(Throwable t) {
        if (t instanceof RuntimeException) {
            return (RuntimeException)t;
        }
        if (t instanceof Error) {
            throw (Error)t;
        }
        return t instanceof InterruptedException ? new AbortedException(t) : new AmazonClientException(t);
    }

    public static RuntimeException failure(Throwable t, String errmsg) {
        if (t instanceof RuntimeException) {
            return (RuntimeException)t;
        }
        if (t instanceof Error) {
            throw (Error)t;
        }
        return t instanceof InterruptedException ? new AbortedException(errmsg, t) : new AmazonClientException(errmsg, t);
    }
}

