/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.sync;

import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import software.amazon.awssdk.http.AbortableInputStream;
import software.amazon.awssdk.utils.IoUtils;

@FunctionalInterface
public interface StreamingResponseHandler<ResponseT, ReturnT> {
    public ReturnT apply(ResponseT var1, AbortableInputStream var2) throws Exception;

    public static <ResponseT> StreamingResponseHandler<ResponseT, Void> toFile(Path path) {
        return (resp, in) -> {
            Files.copy((InputStream)in, path, new CopyOption[0]);
            return null;
        };
    }

    public static <ResponseT> StreamingResponseHandler<ResponseT, Void> toOutputStream(OutputStream outputStream) {
        return (resp, in) -> {
            IoUtils.copy((InputStream)in, (OutputStream)outputStream);
            return null;
        };
    }
}

