/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.runtime.transform;

import javax.xml.xpath.XPath;
import org.w3c.dom.Node;
import software.amazon.awssdk.AmazonServiceException;
import software.amazon.awssdk.annotation.ReviewBeforeRelease;
import software.amazon.awssdk.annotation.SdkProtectedApi;
import software.amazon.awssdk.runtime.transform.AbstractErrorUnmarshaller;
import software.amazon.awssdk.util.XpathUtils;

@SdkProtectedApi
public class StandardErrorUnmarshaller
extends AbstractErrorUnmarshaller<Node> {
    public StandardErrorUnmarshaller() {
    }

    public StandardErrorUnmarshaller(Class<? extends AmazonServiceException> exceptionClass) {
        super(exceptionClass);
    }

    @Override
    public AmazonServiceException unmarshall(Node in) throws Exception {
        XPath xpath = XpathUtils.xpath();
        String errorCode = this.parseErrorCode(in, xpath);
        if (errorCode != null) {
            return this.standardErrorPathException(errorCode, in, xpath);
        }
        return this.s3ErrorPathException(in, xpath);
    }

    public String parseErrorCode(Node in) throws Exception {
        return XpathUtils.asString("ErrorResponse/Error/Code", in);
    }

    public String parseErrorCode(Node in, XPath xpath) throws Exception {
        return XpathUtils.asString("ErrorResponse/Error/Code", in, xpath);
    }

    public String getErrorPropertyPath(String property) {
        return "ErrorResponse/Error/" + property;
    }

    public AmazonServiceException standardErrorPathException(String errorCode, Node in, XPath xpath) throws Exception {
        String errorType = XpathUtils.asString("ErrorResponse/Error/Type", in, xpath);
        String requestId = XpathUtils.asString("ErrorResponse/RequestId", in, xpath);
        String message = XpathUtils.asString("ErrorResponse/Error/Message", in, xpath);
        AmazonServiceException ase = this.newException(message);
        ase.setErrorCode(errorCode);
        ase.setRequestId(requestId);
        if (errorType == null) {
            ase.setErrorType(AmazonServiceException.ErrorType.Unknown);
        } else if (errorType.equalsIgnoreCase("Receiver")) {
            ase.setErrorType(AmazonServiceException.ErrorType.Service);
        } else if (errorType.equalsIgnoreCase("Sender")) {
            ase.setErrorType(AmazonServiceException.ErrorType.Client);
        }
        return ase;
    }

    @ReviewBeforeRelease(value="We shouldn't have S3 speific code in core. Also the way this is doesn't work with modeled exceptions as they are still looking for the error code in the standard location.")
    public AmazonServiceException s3ErrorPathException(Node in, XPath xpath) throws Exception {
        String errorCode = XpathUtils.asString("Error/Code", in, xpath);
        String requestId = XpathUtils.asString("Error/RequestId", in, xpath);
        String message = XpathUtils.asString("Error/Message", in, xpath);
        AmazonServiceException ase = this.newException(message);
        ase.setErrorCode(errorCode);
        ase.setRequestId(requestId);
        return ase;
    }
}

