/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.runtime.transform;

import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.PropertyNamingStrategy;
import java.lang.reflect.Method;
import software.amazon.awssdk.AmazonServiceException;
import software.amazon.awssdk.annotation.ReviewBeforeRelease;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.annotation.ThreadSafe;
import software.amazon.awssdk.runtime.transform.AbstractErrorUnmarshaller;

@SdkInternalApi
@ThreadSafe
public class JsonErrorUnmarshaller
extends AbstractErrorUnmarshaller<JsonNode> {
    public static final JsonErrorUnmarshaller DEFAULT_UNMARSHALLER = new JsonErrorUnmarshaller(AmazonServiceException.class, null);
    private static final ObjectMapper MAPPER = new ObjectMapper().configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false).setPropertyNamingStrategy((PropertyNamingStrategy)new PropertyNamingStrategy.PascalCaseStrategy());
    private final String handledErrorCode;

    public JsonErrorUnmarshaller(Class<? extends AmazonServiceException> exceptionClass, String handledErrorCode) {
        super(exceptionClass);
        this.handledErrorCode = handledErrorCode;
    }

    @Override
    @ReviewBeforeRelease(value="Figure out a better way to go from exception class to it's builder class in order to perform the deserialization")
    public AmazonServiceException unmarshall(JsonNode jsonContent) throws Exception {
        try {
            Method builderClassGetter = this.exceptionClass.getDeclaredMethod("serializableBuilderClass", new Class[0]);
            builderClassGetter.setAccessible(true);
            Class builderClass = (Class)builderClassGetter.invoke(null, new Object[0]);
            Method buildMethod = builderClass.getMethod("build", new Class[0]);
            buildMethod.setAccessible(true);
            Object o = MAPPER.treeToValue((TreeNode)jsonContent, builderClass);
            return (AmazonServiceException)buildMethod.invoke(o, new Object[0]);
        }
        catch (NoSuchMethodException e) {
            return (AmazonServiceException)MAPPER.treeToValue((TreeNode)jsonContent, this.exceptionClass);
        }
    }

    public boolean matchErrorCode(String actualErrorCode) {
        if (this.handledErrorCode == null) {
            return true;
        }
        return this.handledErrorCode.equals(actualErrorCode);
    }
}

