/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.runtime.http.response;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonParser;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.annotation.ReviewBeforeRelease;
import software.amazon.awssdk.annotation.SdkProtectedApi;
import software.amazon.awssdk.http.HttpResponse;
import software.amazon.awssdk.http.HttpResponseHandler;
import software.amazon.awssdk.internal.Crc32MismatchException;
import software.amazon.awssdk.runtime.transform.JsonUnmarshallerContext;
import software.amazon.awssdk.runtime.transform.JsonUnmarshallerContextImpl;
import software.amazon.awssdk.runtime.transform.Unmarshaller;
import software.amazon.awssdk.runtime.transform.VoidJsonUnmarshaller;
import software.amazon.awssdk.util.ValidationUtils;
import software.amazon.awssdk.utils.IoUtils;

@SdkProtectedApi
@ReviewBeforeRelease(value="Metadata in base result has been broken. Fix this and deal with AwsResponseHandlerAdapter")
public class JsonResponseHandler<T>
implements HttpResponseHandler<T> {
    private static final Logger log = LoggerFactory.getLogger((String)"software.amazon.awssdk.request");
    private final JsonFactory jsonFactory;
    private final boolean needsConnectionLeftOpen;
    private final boolean isPayloadJson;
    private final Map<Class<?>, Unmarshaller<?, JsonUnmarshallerContext>> simpleTypeUnmarshallers;
    private Unmarshaller<T, JsonUnmarshallerContext> responseUnmarshaller;

    public JsonResponseHandler(Unmarshaller<T, JsonUnmarshallerContext> responseUnmarshaller, Map<Class<?>, Unmarshaller<?, JsonUnmarshallerContext>> simpleTypeUnmarshallers, JsonFactory jsonFactory, boolean needsConnectionLeftOpen, boolean isPayloadJson) {
        this.responseUnmarshaller = responseUnmarshaller != null ? responseUnmarshaller : new VoidJsonUnmarshaller();
        this.needsConnectionLeftOpen = needsConnectionLeftOpen;
        this.isPayloadJson = isPayloadJson;
        this.simpleTypeUnmarshallers = ValidationUtils.assertNotNull(simpleTypeUnmarshallers, "simple type unmarshallers");
        this.jsonFactory = ValidationUtils.assertNotNull(jsonFactory, "JSONFactory");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public T handle(HttpResponse response) throws Exception {
        log.trace("Parsing service response JSON");
        JsonParser jsonParser = null;
        if (this.shouldParsePayloadAsJson()) {
            jsonParser = this.jsonFactory.createParser(response.getContent());
        }
        try {
            JsonUnmarshallerContextImpl unmarshallerContext = new JsonUnmarshallerContextImpl(jsonParser, this.simpleTypeUnmarshallers, response);
            this.registerAdditionalMetadataExpressions(unmarshallerContext);
            T result = this.responseUnmarshaller.unmarshall(unmarshallerContext);
            if (this.shouldParsePayloadAsJson() && response.getContent() != null) {
                IoUtils.drainInputStream((InputStream)response.getContent());
            }
            log.trace("Done parsing service response");
            T t = result;
            return t;
        }
        finally {
            if (this.shouldParsePayloadAsJson()) {
                try {
                    jsonParser.close();
                }
                catch (Crc32MismatchException e) {
                    throw e;
                }
                catch (IOException e) {
                    log.warn("Error closing json parser", (Throwable)e);
                }
            }
        }
    }

    protected void registerAdditionalMetadataExpressions(JsonUnmarshallerContext unmarshallerContext) {
    }

    @Override
    public boolean needsConnectionLeftOpen() {
        return this.needsConnectionLeftOpen;
    }

    private boolean shouldParsePayloadAsJson() {
        return !this.needsConnectionLeftOpen && this.isPayloadJson;
    }
}

