/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.runtime.http;

import com.fasterxml.jackson.databind.JsonNode;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import software.amazon.awssdk.annotation.SdkProtectedApi;
import software.amazon.awssdk.http.HttpResponse;

@SdkProtectedApi
public class JsonErrorMessageParser {
    public static final String X_AMZN_ERROR_MESSAGE = "x-amzn-error-message";
    private static final List<String> DEFAULT_ERROR_MESSAGE_LOCATIONS = Arrays.asList("message", "Message", "errorMessage");
    public static final JsonErrorMessageParser DEFAULT_ERROR_MESSAGE_PARSER = new JsonErrorMessageParser(DEFAULT_ERROR_MESSAGE_LOCATIONS);
    private static final HttpResponse EMPTY_HTTP_RESPONSE = new HttpResponse(null);
    private final List<String> errorMessageJsonLocations;

    public JsonErrorMessageParser(List<String> errorMessageJsonLocations) {
        this.errorMessageJsonLocations = new LinkedList<String>(errorMessageJsonLocations);
    }

    @Deprecated
    public String parseErrorMessage(JsonNode jsonNode) {
        return this.parseErrorMessage(EMPTY_HTTP_RESPONSE, jsonNode);
    }

    public String parseErrorMessage(HttpResponse httpResponse, JsonNode jsonNode) {
        String headerMessage = httpResponse.getHeader(X_AMZN_ERROR_MESSAGE);
        if (headerMessage != null) {
            return headerMessage;
        }
        for (String field : this.errorMessageJsonLocations) {
            JsonNode value = jsonNode.get(field);
            if (value == null || !value.isTextual()) continue;
            return value.asText();
        }
        return null;
    }
}

