/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.retry;

import software.amazon.awssdk.AmazonClientException;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.LegacyClientConfiguration;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.retry.v2.RetryPolicy;
import software.amazon.awssdk.retry.v2.RetryPolicyContext;
import software.amazon.awssdk.util.ValidationUtils;

@SdkInternalApi
public class RetryPolicyAdapter
implements RetryPolicy {
    private final software.amazon.awssdk.retry.RetryPolicy legacyRetryPolicy;
    private final LegacyClientConfiguration clientConfiguration;

    public RetryPolicyAdapter(software.amazon.awssdk.retry.RetryPolicy legacyRetryPolicy, LegacyClientConfiguration clientConfiguration) {
        this.legacyRetryPolicy = ValidationUtils.assertNotNull(legacyRetryPolicy, "legacyRetryPolicy");
        this.clientConfiguration = ValidationUtils.assertNotNull(clientConfiguration, "clientConfiguration");
    }

    @Override
    public long computeDelayBeforeNextRetry(RetryPolicyContext context) {
        return this.legacyRetryPolicy.getBackoffStrategy().delayBeforeNextRetry((AmazonWebServiceRequest)context.originalRequest(), this.tryConvertException(context.exception()), context.retriesAttempted());
    }

    @Override
    public boolean shouldRetry(RetryPolicyContext context) {
        if (context.retriesAttempted() >= this.getMaxErrorRetry()) {
            return false;
        }
        return this.legacyRetryPolicy.getRetryCondition().shouldRetry((AmazonWebServiceRequest)context.originalRequest(), this.tryConvertException(context.exception()), context.retriesAttempted());
    }

    private AmazonClientException tryConvertException(Exception e) {
        if (e instanceof AmazonClientException) {
            return (AmazonClientException)e;
        }
        return null;
    }

    public software.amazon.awssdk.retry.RetryPolicy getLegacyRetryPolicy() {
        return this.legacyRetryPolicy;
    }

    private int getMaxErrorRetry() {
        if (this.legacyRetryPolicy.isMaxErrorRetryInClientConfigHonored() && this.clientConfiguration.getMaxErrorRetry() >= 0) {
            return this.clientConfiguration.getMaxErrorRetry();
        }
        return this.legacyRetryPolicy.getMaxErrorRetry();
    }
}

