/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.protocol.json;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.time.Instant;
import java.util.Date;
import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.json.StructuredJsonGenerator;
import software.amazon.awssdk.utils.BinaryUtils;
import software.amazon.ion.IonType;
import software.amazon.ion.IonWriter;
import software.amazon.ion.Timestamp;
import software.amazon.ion.system.IonWriterBuilder;

@SdkInternalApi
abstract class SdkIonGenerator
implements StructuredJsonGenerator {
    protected final IonWriter writer;
    private final String contentType;

    private SdkIonGenerator(IonWriter writer, String contentType) {
        this.writer = writer;
        this.contentType = contentType;
    }

    public static SdkIonGenerator create(IonWriterBuilder builder, String contentType) {
        ByteArrayOutputStream bytes = new ByteArrayOutputStream();
        IonWriter writer = builder.build((OutputStream)bytes);
        return new ByteArraySdkIonGenerator(bytes, writer, contentType);
    }

    @Override
    public StructuredJsonGenerator writeStartArray() {
        try {
            this.writer.stepIn(IonType.LIST);
        }
        catch (IOException e) {
            throw new SdkClientException(e);
        }
        return this;
    }

    @Override
    public StructuredJsonGenerator writeNull() {
        try {
            this.writer.writeNull();
        }
        catch (IOException e) {
            throw new SdkClientException(e);
        }
        return this;
    }

    @Override
    public StructuredJsonGenerator writeEndArray() {
        try {
            this.writer.stepOut();
        }
        catch (IOException e) {
            throw new SdkClientException(e);
        }
        return this;
    }

    @Override
    public StructuredJsonGenerator writeStartObject() {
        try {
            this.writer.stepIn(IonType.STRUCT);
        }
        catch (IOException e) {
            throw new SdkClientException(e);
        }
        return this;
    }

    @Override
    public StructuredJsonGenerator writeEndObject() {
        try {
            this.writer.stepOut();
        }
        catch (IOException e) {
            throw new SdkClientException(e);
        }
        return this;
    }

    @Override
    public StructuredJsonGenerator writeFieldName(String fieldName) {
        this.writer.setFieldName(fieldName);
        return this;
    }

    @Override
    public StructuredJsonGenerator writeValue(String val) {
        try {
            this.writer.writeString(val);
        }
        catch (IOException e) {
            throw new SdkClientException(e);
        }
        return this;
    }

    @Override
    public StructuredJsonGenerator writeValue(boolean bool) {
        try {
            this.writer.writeBool(bool);
        }
        catch (IOException e) {
            throw new SdkClientException(e);
        }
        return this;
    }

    @Override
    public StructuredJsonGenerator writeValue(long val) {
        try {
            this.writer.writeInt(val);
        }
        catch (IOException e) {
            throw new SdkClientException(e);
        }
        return this;
    }

    @Override
    public StructuredJsonGenerator writeValue(double val) {
        try {
            this.writer.writeFloat(val);
        }
        catch (IOException e) {
            throw new SdkClientException(e);
        }
        return this;
    }

    @Override
    public StructuredJsonGenerator writeValue(float val) {
        try {
            this.writer.writeFloat((double)val);
        }
        catch (IOException e) {
            throw new SdkClientException(e);
        }
        return this;
    }

    @Override
    public StructuredJsonGenerator writeValue(short val) {
        try {
            this.writer.writeInt((long)val);
        }
        catch (IOException e) {
            throw new SdkClientException(e);
        }
        return this;
    }

    @Override
    public StructuredJsonGenerator writeValue(int val) {
        try {
            this.writer.writeInt((long)val);
        }
        catch (IOException e) {
            throw new SdkClientException(e);
        }
        return this;
    }

    @Override
    public StructuredJsonGenerator writeValue(ByteBuffer bytes) {
        try {
            this.writer.writeBlob(BinaryUtils.copyAllBytesFrom((ByteBuffer)bytes));
        }
        catch (IOException e) {
            throw new SdkClientException(e);
        }
        return this;
    }

    @Override
    public StructuredJsonGenerator writeValue(Instant instant) {
        try {
            Date d = instant != null ? Date.from(instant) : null;
            this.writer.writeTimestamp(Timestamp.forDateZ((Date)d));
        }
        catch (IOException e) {
            throw new SdkClientException(e);
        }
        return this;
    }

    @Override
    public StructuredJsonGenerator writeValue(BigDecimal value) {
        try {
            this.writer.writeDecimal(value);
        }
        catch (IOException e) {
            throw new SdkClientException(e);
        }
        return this;
    }

    @Override
    public StructuredJsonGenerator writeValue(BigInteger value) {
        try {
            this.writer.writeInt(value);
        }
        catch (IOException e) {
            throw new SdkClientException(e);
        }
        return this;
    }

    @Override
    public abstract byte[] getBytes();

    @Override
    public String getContentType() {
        return this.contentType;
    }

    private static class ByteArraySdkIonGenerator
    extends SdkIonGenerator {
        private final ByteArrayOutputStream bytes;

        ByteArraySdkIonGenerator(ByteArrayOutputStream bytes, IonWriter writer, String contentType) {
            super(writer, contentType);
            this.bytes = bytes;
        }

        @Override
        public byte[] getBytes() {
            try {
                this.writer.finish();
            }
            catch (IOException e) {
                throw new SdkClientException(e);
            }
            return this.bytes.toByteArray();
        }
    }
}

