/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.metrics;

import org.slf4j.LoggerFactory;
import software.amazon.awssdk.annotation.NotThreadSafe;
import software.amazon.awssdk.metrics.ServiceMetricType;
import software.amazon.awssdk.metrics.spi.TimingInfo;

@NotThreadSafe
public class ServiceLatencyProvider {
    private final long startNano;
    private final ServiceMetricType serviceMetricType;
    private long endNano;

    public ServiceLatencyProvider(ServiceMetricType type) {
        this.endNano = this.startNano = System.nanoTime();
        this.serviceMetricType = type;
    }

    public ServiceMetricType getServiceMetricType() {
        return this.serviceMetricType;
    }

    public ServiceLatencyProvider endTiming() {
        if (this.endNano != this.startNano) {
            throw new IllegalStateException();
        }
        this.endNano = System.nanoTime();
        return this;
    }

    public double getDurationMilli() {
        if (this.endNano == this.startNano) {
            LoggerFactory.getLogger(this.getClass()).debug("Likely to be a missing invocation of endTiming().");
        }
        return TimingInfo.durationMilliOf((long)this.startNano, (long)this.endNano);
    }

    public String getProviderId() {
        return super.toString();
    }

    public String toString() {
        return String.format("providerId=%s, serviceMetricType=%s, startNano=%d, endNano=%d", this.getProviderId(), this.serviceMetricType, this.startNano, this.endNano);
    }
}

