/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.jmx.spi;

import org.slf4j.LoggerFactory;

public interface JmxInfoProvider {
    public static final JmxInfoProvider NONE = new JmxInfoProvider(){

        @Override
        public long[] getFileDecriptorInfo() {
            return null;
        }

        @Override
        public int getThreadCount() {
            return 0;
        }

        @Override
        public int getDaemonThreadCount() {
            return 0;
        }

        @Override
        public int getPeakThreadCount() {
            return 0;
        }

        @Override
        public long getTotalStartedThreadCount() {
            return 0L;
        }

        @Override
        public long[] findDeadlockedThreads() {
            return null;
        }

        @Override
        public boolean isEnabled() {
            return false;
        }
    };

    public long[] getFileDecriptorInfo();

    public int getThreadCount();

    public int getDaemonThreadCount();

    public int getPeakThreadCount();

    public long getTotalStartedThreadCount();

    public long[] findDeadlockedThreads();

    public boolean isEnabled();

    public static class Factory {
        private static final JmxInfoProvider PROVIDER;

        public static JmxInfoProvider getJmxInfoProvider() {
            return PROVIDER;
        }

        static {
            JmxInfoProvider p;
            try {
                Class<?> c = Class.forName("software.amazon.awssdk.jmx.JmxInfoProviderSupport");
                p = (JmxInfoProvider)c.newInstance();
            }
            catch (Exception e) {
                LoggerFactory.getLogger(JmxInfoProvider.class).debug("Failed to load the JMX implementation module - JMX is disabled", (Throwable)e);
                p = NONE;
            }
            PROVIDER = p;
        }
    }
}

