/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.internal.region.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;
import software.amazon.awssdk.Protocol;
import software.amazon.awssdk.internal.region.model.CredentialScope;

public class Endpoint
implements Cloneable {
    private String hostname;
    private CredentialScope credentialScope;
    private List<String> protocols;
    private List<String> signatureVersions;
    private String sslCommonName;

    public Endpoint merge(Endpoint higher) {
        if (higher == null) {
            higher = new Endpoint();
        }
        Endpoint merged = this.clone();
        merged.setCredentialScope(higher.getCredentialScope() != null ? higher.getCredentialScope() : merged.getCredentialScope());
        merged.setHostname(higher.getHostname() != null ? higher.getHostname() : merged.getHostname());
        merged.setSslCommonName(higher.getSslCommonName() != null ? higher.getSslCommonName() : merged.getSslCommonName());
        merged.setProtocols(higher.getProtocols() != null ? higher.getProtocols() : merged.getProtocols());
        merged.setSignatureVersions(higher.getSignatureVersions() != null ? higher.getSignatureVersions() : merged.getSignatureVersions());
        return merged;
    }

    public String getHostname() {
        return this.hostname;
    }

    @JsonProperty(value="hostname")
    public void setHostname(String hostname) {
        this.hostname = hostname;
    }

    public CredentialScope getCredentialScope() {
        return this.credentialScope;
    }

    @JsonProperty(value="credentialScope")
    public void setCredentialScope(CredentialScope credentialScope) {
        this.credentialScope = credentialScope;
    }

    public List<String> getProtocols() {
        return this.protocols;
    }

    public void setProtocols(List<String> protocols) {
        this.protocols = protocols;
    }

    public List<String> getSignatureVersions() {
        return this.signatureVersions;
    }

    @JsonProperty(value="signatureVersions")
    public void setSignatureVersions(List<String> signatureVersions) {
        this.signatureVersions = signatureVersions;
    }

    public String getSslCommonName() {
        return this.sslCommonName;
    }

    @JsonProperty(value="sslCommonName")
    public void setSslCommonName(String sslCommonName) {
        this.sslCommonName = sslCommonName;
    }

    public boolean hasHttpsSupport() {
        return this.isProtocolSupported(Protocol.HTTPS);
    }

    public boolean hasHttpSupport() {
        return this.isProtocolSupported(Protocol.HTTP);
    }

    private boolean isProtocolSupported(Protocol protocol) {
        return this.protocols != null && this.protocols.contains(protocol.toString());
    }

    protected Endpoint clone() {
        try {
            return (Endpoint)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

