/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.internal.http.timers.client;

import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.annotation.SdkTestInternalApi;
import software.amazon.awssdk.annotation.ThreadSafe;
import software.amazon.awssdk.internal.http.timers.TimeoutThreadPoolBuilder;
import software.amazon.awssdk.internal.http.timers.client.ClientExecutionAbortTaskImpl;
import software.amazon.awssdk.internal.http.timers.client.ClientExecutionAbortTrackerTask;
import software.amazon.awssdk.internal.http.timers.client.ClientExecutionAbortTrackerTaskImpl;
import software.amazon.awssdk.internal.http.timers.client.NoOpClientExecutionAbortTrackerTask;

@SdkInternalApi
@ThreadSafe
public class ClientExecutionTimer
implements AutoCloseable {
    private static final String THREAD_NAME_PREFIX = "AwsSdkClientExecutionTimerThread";
    private volatile ScheduledThreadPoolExecutor executor;

    public ClientExecutionAbortTrackerTask startTimer(int clientExecutionTimeoutMillis) {
        if (this.isTimeoutDisabled(clientExecutionTimeoutMillis)) {
            return NoOpClientExecutionAbortTrackerTask.INSTANCE;
        }
        if (this.executor == null) {
            this.initializeExecutor();
        }
        return this.scheduleTimerTask(clientExecutionTimeoutMillis);
    }

    private synchronized void initializeExecutor() {
        if (this.executor == null) {
            this.executor = TimeoutThreadPoolBuilder.buildDefaultTimeoutThreadPool(THREAD_NAME_PREFIX);
        }
    }

    @SdkTestInternalApi
    public ScheduledThreadPoolExecutor getExecutor() {
        return this.executor;
    }

    @Override
    public void close() throws Exception {
        if (this.executor != null) {
            this.executor.shutdown();
        }
    }

    private ClientExecutionAbortTrackerTask scheduleTimerTask(int clientExecutionTimeoutMillis) {
        ClientExecutionAbortTaskImpl timerTask = new ClientExecutionAbortTaskImpl(Thread.currentThread());
        ScheduledFuture<?> timerTaskFuture = this.executor.schedule(timerTask, (long)clientExecutionTimeoutMillis, TimeUnit.MILLISECONDS);
        return new ClientExecutionAbortTrackerTaskImpl(timerTask, timerTaskFuture);
    }

    private boolean isTimeoutDisabled(int clientExecutionTimeoutMillis) {
        return clientExecutionTimeoutMillis <= 0;
    }
}

