/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.http.pipeline.stages;

import software.amazon.awssdk.RequestExecutionContext;
import software.amazon.awssdk.auth.AwsCredentials;
import software.amazon.awssdk.auth.CanHandleNullCredentials;
import software.amazon.awssdk.auth.Signer;
import software.amazon.awssdk.handlers.AwsHandlerKeys;
import software.amazon.awssdk.http.AmazonHttpClient;
import software.amazon.awssdk.http.HttpClientDependencies;
import software.amazon.awssdk.http.SdkHttpFullRequest;
import software.amazon.awssdk.http.pipeline.RequestToRequestPipeline;
import software.amazon.awssdk.metrics.spi.AwsRequestMetrics;
import software.amazon.awssdk.metrics.spi.MetricType;
import software.amazon.awssdk.runtime.auth.SignerProviderContext;

public class SigningStage
implements RequestToRequestPipeline {
    private final HttpClientDependencies dependencies;

    public SigningStage(HttpClientDependencies dependencies) {
        this.dependencies = dependencies;
    }

    @Override
    public SdkHttpFullRequest execute(SdkHttpFullRequest request, RequestExecutionContext context) throws Exception {
        AmazonHttpClient.checkInterrupted();
        return this.signRequest(request, context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SdkHttpFullRequest signRequest(SdkHttpFullRequest request, RequestExecutionContext context) {
        AwsCredentials credentials = context.credentialsProvider().getCredentials();
        Signer signer = this.newSigner(request, context);
        if (this.shouldSign(signer, credentials)) {
            context.awsRequestMetrics().startEvent((MetricType)AwsRequestMetrics.Field.RequestSigningTime);
            try {
                SdkHttpFullRequest sdkHttpFullRequest = signer.sign(this.adjustForClockSkew(request), credentials);
                return sdkHttpFullRequest;
            }
            finally {
                context.awsRequestMetrics().endEvent((MetricType)AwsRequestMetrics.Field.RequestSigningTime);
            }
        }
        return request;
    }

    private Signer newSigner(SdkHttpFullRequest request, RequestExecutionContext context) {
        SignerProviderContext.Builder signerProviderContext = SignerProviderContext.builder().withRequest(request).withRequestConfig(context.requestConfig());
        return context.signerProvider().getSigner(signerProviderContext.withUri(request.getEndpoint()).build());
    }

    private boolean shouldSign(Signer signer, AwsCredentials credentials) {
        return signer != null && (credentials != null || signer instanceof CanHandleNullCredentials);
    }

    private SdkHttpFullRequest adjustForClockSkew(SdkHttpFullRequest request) {
        if (this.dependencies.timeOffset() != 0) {
            return (SdkHttpFullRequest)((SdkHttpFullRequest.Builder)request.toBuilder()).handlerContext(AwsHandlerKeys.TIME_OFFSET, (Object)this.dependencies.timeOffset()).build();
        }
        return request;
    }
}

