/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.http.async;

import java.io.InputStream;
import java.nio.ByteBuffer;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.RequestConfig;
import software.amazon.awssdk.handlers.AwsHandlerKeys;
import software.amazon.awssdk.http.SdkHttpFullRequest;
import software.amazon.awssdk.http.async.SdkHttpRequestProvider;
import software.amazon.awssdk.utils.FunctionalUtils;
import software.amazon.awssdk.utils.IoUtils;

public class SimpleRequestProvider
implements SdkHttpRequestProvider {
    private final byte[] content;
    private final int length;

    public SimpleRequestProvider(SdkHttpFullRequest request) {
        if (request.getContent() != null) {
            request.getContent().mark(this.getReadLimit(request));
            this.content = (byte[])FunctionalUtils.invokeSafely(() -> IoUtils.toByteArray((InputStream)request.getContent()));
            FunctionalUtils.invokeSafely(() -> request.getContent().reset());
        } else {
            this.content = new byte[0];
        }
        this.length = this.content.length;
    }

    private int getReadLimit(SdkHttpFullRequest request) {
        return ((RequestConfig)request.handlerContext(AwsHandlerKeys.REQUEST_CONFIG)).getRequestClientOptions().getReadLimit();
    }

    public long contentLength() {
        return this.length;
    }

    public void subscribe(final Subscriber<? super ByteBuffer> s) {
        s.onSubscribe(new Subscription(){

            public void request(long n) {
                s.onNext((Object)ByteBuffer.wrap(SimpleRequestProvider.this.content));
                s.onComplete();
            }

            public void cancel() {
            }
        });
    }
}

