/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.http;

import java.util.Collections;
import java.util.Map;
import software.amazon.awssdk.annotation.Immutable;
import software.amazon.awssdk.annotation.SdkPublicApi;
import software.amazon.awssdk.http.HttpResponse;

@Immutable
@SdkPublicApi
public class SdkHttpMetadata {
    private final Map<String, String> httpHeaders;
    private final int httpStatusCode;

    private SdkHttpMetadata(Map<String, String> httpHeaders, int httpStatusCode) {
        this.httpHeaders = Collections.unmodifiableMap(httpHeaders);
        this.httpStatusCode = httpStatusCode;
    }

    public static SdkHttpMetadata from(HttpResponse httpResponse) {
        return new SdkHttpMetadata(httpResponse.getHeaders(), httpResponse.getStatusCode());
    }

    public Map<String, String> getHttpHeaders() {
        return this.httpHeaders;
    }

    public int getHttpStatusCode() {
        return this.httpStatusCode;
    }
}

