/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.http;

import java.util.List;
import software.amazon.awssdk.annotation.NotThreadSafe;
import software.amazon.awssdk.annotation.SdkProtectedApi;
import software.amazon.awssdk.auth.AwsCredentialsProvider;
import software.amazon.awssdk.auth.Signer;
import software.amazon.awssdk.handlers.RequestHandler;
import software.amazon.awssdk.internal.auth.NoOpSignerProvider;
import software.amazon.awssdk.internal.http.timers.client.ClientExecutionAbortTrackerTask;
import software.amazon.awssdk.metrics.spi.AwsRequestMetrics;
import software.amazon.awssdk.runtime.auth.SignerProvider;
import software.amazon.awssdk.runtime.auth.SignerProviderContext;
import software.amazon.awssdk.util.AwsRequestMetricsFullSupport;

@NotThreadSafe
@SdkProtectedApi
public class ExecutionContext {
    private final AwsRequestMetrics awsRequestMetrics;
    private final List<RequestHandler> requestHandlers;
    private final SignerProvider signerProvider;
    private boolean retryCapacityConsumed;
    private AwsCredentialsProvider credentialsProvider;
    private ClientExecutionAbortTrackerTask clientExecutionTrackerTask;

    public ExecutionContext(boolean isMetricEnabled) {
        this(ExecutionContext.builder().withUseRequestMetrics(isMetricEnabled).withSignerProvider(new NoOpSignerProvider()));
    }

    public ExecutionContext() {
        this(ExecutionContext.builder().withSignerProvider(new NoOpSignerProvider()));
    }

    private ExecutionContext(Builder builder) {
        this.requestHandlers = builder.requestHandlers;
        this.awsRequestMetrics = builder.useRequestMetrics ? new AwsRequestMetricsFullSupport() : new AwsRequestMetrics();
        this.signerProvider = builder.signerProvider;
    }

    public static Builder builder() {
        return new Builder();
    }

    public List<RequestHandler> getRequestHandlers() {
        return this.requestHandlers;
    }

    public AwsRequestMetrics getAwsRequestMetrics() {
        return this.awsRequestMetrics;
    }

    @Deprecated
    public void setSigner(Signer signer) {
    }

    public boolean retryCapacityConsumed() {
        return this.retryCapacityConsumed;
    }

    public void markRetryCapacityConsumed() {
        this.retryCapacityConsumed = true;
    }

    public Signer getSigner(SignerProviderContext context) {
        return this.signerProvider.getSigner(context);
    }

    public AwsCredentialsProvider getCredentialsProvider() {
        return this.credentialsProvider;
    }

    public void setCredentialsProvider(AwsCredentialsProvider credentialsProvider) {
        this.credentialsProvider = credentialsProvider;
    }

    public ClientExecutionAbortTrackerTask getClientExecutionTrackerTask() {
        return this.clientExecutionTrackerTask;
    }

    public void setClientExecutionTrackerTask(ClientExecutionAbortTrackerTask clientExecutionTrackerTask) {
        this.clientExecutionTrackerTask = clientExecutionTrackerTask;
    }

    public SignerProvider getSignerProvider() {
        return this.signerProvider;
    }

    public static class Builder {
        private boolean useRequestMetrics;
        private List<RequestHandler> requestHandlers;
        private SignerProvider signerProvider = new NoOpSignerProvider();

        private Builder() {
        }

        public boolean useRequestMetrics() {
            return this.useRequestMetrics;
        }

        public void setUseRequestMetrics(boolean useRequestMetrics) {
            this.useRequestMetrics = useRequestMetrics;
        }

        public Builder withUseRequestMetrics(boolean withUseRequestMetrics) {
            this.setUseRequestMetrics(withUseRequestMetrics);
            return this;
        }

        public List<RequestHandler> getRequestHandlers() {
            return this.requestHandlers;
        }

        public void setRequestHandlers(List<RequestHandler> requestHandlers) {
            this.requestHandlers = requestHandlers;
        }

        public Builder withRequestHandlers(List<RequestHandler> requestHandlers) {
            this.setRequestHandlers(requestHandlers);
            return this;
        }

        public SignerProvider getSignerProvider() {
            return this.signerProvider;
        }

        public void setSignerProvider(SignerProvider signerProvider) {
            this.signerProvider = signerProvider;
        }

        public Builder withSignerProvider(SignerProvider signerProvider) {
            this.setSignerProvider(signerProvider);
            return this;
        }

        public ExecutionContext build() {
            return new ExecutionContext(this);
        }
    }
}

