/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.http;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ScheduledExecutorService;
import software.amazon.awssdk.LegacyClientConfiguration;
import software.amazon.awssdk.RequestConfig;
import software.amazon.awssdk.RequestExecutionContext;
import software.amazon.awssdk.Response;
import software.amazon.awssdk.SdkBaseException;
import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.annotation.SdkProtectedApi;
import software.amazon.awssdk.annotation.ThreadSafe;
import software.amazon.awssdk.http.ExecutionContext;
import software.amazon.awssdk.http.HttpClientDependencies;
import software.amazon.awssdk.http.SdkHttpFullRequest;
import software.amazon.awssdk.http.async.SdkAsyncHttpClient;
import software.amazon.awssdk.http.async.SdkHttpRequestProvider;
import software.amazon.awssdk.http.async.SdkHttpResponseHandler;
import software.amazon.awssdk.http.pipeline.RequestPipelineBuilder;
import software.amazon.awssdk.http.pipeline.stages.ApplyTransactionIdStage;
import software.amazon.awssdk.http.pipeline.stages.ApplyUserAgentStage;
import software.amazon.awssdk.http.pipeline.stages.AsyncRetryableStage;
import software.amazon.awssdk.http.pipeline.stages.BeforeRequestHandlersStage;
import software.amazon.awssdk.http.pipeline.stages.MakeAsyncHttpRequestStage;
import software.amazon.awssdk.http.pipeline.stages.MakeRequestImmutable;
import software.amazon.awssdk.http.pipeline.stages.MakeRequestMutable;
import software.amazon.awssdk.http.pipeline.stages.MergeCustomHeadersStage;
import software.amazon.awssdk.http.pipeline.stages.MergeCustomQueryParamsStage;
import software.amazon.awssdk.http.pipeline.stages.MoveParametersToBodyStage;
import software.amazon.awssdk.http.pipeline.stages.ReportRequestContentLengthStage;
import software.amazon.awssdk.http.pipeline.stages.SigningStage;
import software.amazon.awssdk.http.pipeline.stages.UnwrapResponseContainer;
import software.amazon.awssdk.internal.http.timers.client.ClientExecutionTimer;
import software.amazon.awssdk.metrics.RequestMetricCollector;
import software.amazon.awssdk.retry.RetryPolicyAdapter;
import software.amazon.awssdk.retry.v2.RetryPolicy;
import software.amazon.awssdk.util.CapacityManager;
import software.amazon.awssdk.utils.Validate;

@ThreadSafe
@SdkProtectedApi
public class AmazonAsyncHttpClient
implements AutoCloseable {
    private final RequestMetricCollector requestMetricCollector;
    private final HttpClientDependencies httpClientDependencies;

    private AmazonAsyncHttpClient(HttpClientDependencies httpClientDependencies, RequestMetricCollector requestMetricCollector) {
        this.httpClientDependencies = (HttpClientDependencies)Validate.paramNotNull((Object)httpClientDependencies, (String)"HttpClientDependencies");
        this.requestMetricCollector = requestMetricCollector;
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public void close() throws Exception {
        this.httpClientDependencies.close();
    }

    public RequestMetricCollector getRequestMetricCollector() {
        return this.requestMetricCollector;
    }

    public RequestExecutionBuilder requestExecutionBuilder() {
        return new RequestExecutionBuilderImpl();
    }

    private class RequestExecutionBuilderImpl
    implements RequestExecutionBuilder {
        private SdkHttpRequestProvider requestProvider;
        private SdkHttpFullRequest request;
        private RequestConfig requestConfig;
        private SdkHttpResponseHandler<? extends SdkBaseException> errorResponseHandler;
        private ExecutionContext executionContext = new ExecutionContext();

        private RequestExecutionBuilderImpl() {
        }

        @Override
        public RequestExecutionBuilder requestProvider(SdkHttpRequestProvider requestProvider) {
            this.requestProvider = requestProvider;
            return this;
        }

        @Override
        public RequestExecutionBuilder request(SdkHttpFullRequest request) {
            this.request = request;
            return this;
        }

        @Override
        public RequestExecutionBuilder errorResponseHandler(SdkHttpResponseHandler<? extends SdkBaseException> errorResponseHandler) {
            this.errorResponseHandler = errorResponseHandler;
            return this;
        }

        @Override
        public RequestExecutionBuilder executionContext(ExecutionContext executionContext) {
            this.executionContext = executionContext;
            return this;
        }

        @Override
        public RequestExecutionBuilder requestConfig(RequestConfig requestConfig) {
            this.requestConfig = requestConfig;
            return this;
        }

        @Override
        public <OutputT> CompletableFuture<OutputT> execute(SdkHttpResponseHandler<OutputT> responseHandler) {
            try {
                return (CompletableFuture)RequestPipelineBuilder.first(BeforeRequestHandlersStage::new).then(MakeRequestMutable::new).then(ApplyTransactionIdStage::new).then(ApplyUserAgentStage::new).then(MergeCustomHeadersStage::new).then(MergeCustomQueryParamsStage::new).then(MoveParametersToBodyStage::new).then(MakeRequestImmutable::new).then(ReportRequestContentLengthStage::new).then(RequestPipelineBuilder.first(SigningStage::new).then(d -> new MakeAsyncHttpRequestStage(responseHandler, (SdkHttpResponseHandler<SdkBaseException>)this.errorResponseHandler, (HttpClientDependencies)d)).wrap(AsyncRetryableStage::new)::build).then(RequestPipelineBuilder.async(() -> new UnwrapResponseContainer())).build(AmazonAsyncHttpClient.this.httpClientDependencies).execute(this.request, this.createRequestExecutionDependencies());
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                throw new SdkClientException(e);
            }
        }

        @Override
        public CompletableFuture<Response<Void>> execute() {
            return this.execute(null);
        }

        private RequestExecutionContext createRequestExecutionDependencies() {
            return RequestExecutionContext.builder().requestProvider(this.requestProvider).requestConfig(this.requestConfig).executionContext(this.executionContext).build();
        }
    }

    public static class Builder {
        private LegacyClientConfiguration clientConfig;
        private RetryPolicy retryPolicy;
        private RequestMetricCollector requestMetricCollector;
        private boolean calculateCrc32FromCompressedData;
        private SdkAsyncHttpClient sdkAsyncHttpClient;
        private ScheduledExecutorService executorService;

        private Builder() {
        }

        public Builder clientConfiguration(LegacyClientConfiguration clientConfig) {
            this.clientConfig = clientConfig;
            return this;
        }

        public Builder retryPolicy(RetryPolicy retryPolicy) {
            this.retryPolicy = retryPolicy;
            return this;
        }

        public Builder requestMetricCollector(RequestMetricCollector requestMetricCollector) {
            this.requestMetricCollector = requestMetricCollector;
            return this;
        }

        public Builder calculateCrc32FromCompressedData(boolean calculateCrc32FromCompressedData) {
            this.calculateCrc32FromCompressedData = calculateCrc32FromCompressedData;
            return this;
        }

        public Builder sdkAsyncHttpClient(SdkAsyncHttpClient sdkAsyncHttpClient) {
            this.sdkAsyncHttpClient = sdkAsyncHttpClient;
            return this;
        }

        public Builder asyncExecutor(ScheduledExecutorService executorService) {
            this.executorService = executorService;
            return this;
        }

        public AmazonAsyncHttpClient build() {
            return new AmazonAsyncHttpClient(HttpClientDependencies.builder().clientExecutionTimer(new ClientExecutionTimer()).config(this.clientConfig).retryCapacity(this.createCapacityManager()).retryPolicy(this.resolveRetryPolicy()).calculateCrc32FromCompressedData(this.calculateCrc32FromCompressedData).sdkAsyncHttpClient(this.sdkAsyncHttpClient).asyncExecutorService(this.executorService).build(), this.requestMetricCollector);
        }

        private CapacityManager createCapacityManager() {
            int throttledRetryMaxCapacity = this.clientConfig.useThrottledRetries() ? 500 : -1;
            return new CapacityManager(throttledRetryMaxCapacity);
        }

        private RetryPolicy resolveRetryPolicy() {
            return this.retryPolicy == null ? new RetryPolicyAdapter(this.clientConfig.getRetryPolicy(), this.clientConfig) : this.retryPolicy;
        }
    }

    public static interface RequestExecutionBuilder {
        public RequestExecutionBuilder requestProvider(SdkHttpRequestProvider var1);

        public RequestExecutionBuilder request(SdkHttpFullRequest var1);

        public RequestExecutionBuilder errorResponseHandler(SdkHttpResponseHandler<? extends SdkBaseException> var1);

        public RequestExecutionBuilder executionContext(ExecutionContext var1);

        public RequestExecutionBuilder requestConfig(RequestConfig var1);

        public <OutputT> CompletableFuture<OutputT> execute(SdkHttpResponseHandler<OutputT> var1);

        public CompletableFuture<Response<Void>> execute();
    }
}

