/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.handlers;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import software.amazon.awssdk.AmazonClientException;
import software.amazon.awssdk.handlers.RequestHandler;
import software.amazon.awssdk.util.ClassLoaderHelper;
import software.amazon.awssdk.util.StringUtils;

public final class HandlerChainFactory {
    private static final String GLOBAL_HANDLER_PATH = "software/amazon/awssdk/global/handlers/request.handler2s";

    public List<RequestHandler> newRequestHandlerChain(String resource) {
        return this.createRequestHandlerChain(resource, RequestHandler.class);
    }

    public List<RequestHandler> getGlobalHandlers() {
        ArrayList<RequestHandler> handlers = new ArrayList<RequestHandler>();
        BufferedReader fileReader = null;
        try {
            ArrayList<URL> globalHandlerListLocations = Collections.list(HandlerChainFactory.class.getClassLoader().getResources(GLOBAL_HANDLER_PATH));
            for (URL url : globalHandlerListLocations) {
                String requestHandlerClassName;
                fileReader = new BufferedReader(new InputStreamReader(url.openStream(), StringUtils.UTF8));
                while ((requestHandlerClassName = fileReader.readLine()) != null) {
                    RequestHandler requestHandler = this.createRequestHandler(requestHandlerClassName, RequestHandler.class);
                    if (requestHandler == null) continue;
                    handlers.add(requestHandler);
                }
            }
        }
        catch (IOException | ClassNotFoundException | IllegalAccessException | InstantiationException | RuntimeException e) {
            throw new AmazonClientException("Unable to instantiate request handler chain for client: " + e.getMessage(), e);
        }
        finally {
            try {
                if (fileReader != null) {
                    fileReader.close();
                }
            }
            catch (IOException iOException) {}
        }
        return handlers;
    }

    private RequestHandler createRequestHandler(String handlerClassName, Class<?> handlerApiClass) throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        if ((handlerClassName = handlerClassName.trim()).equals("")) {
            return null;
        }
        Class<?> requestHandlerClass = ClassLoaderHelper.loadClass(handlerClassName, handlerApiClass, this.getClass());
        Object requestHandlerObject = requestHandlerClass.newInstance();
        if (handlerApiClass.isInstance(requestHandlerObject)) {
            if (handlerApiClass == RequestHandler.class) {
                return (RequestHandler)requestHandlerObject;
            }
            throw new IllegalStateException();
        }
        throw new AmazonClientException("Unable to instantiate request handler chain for client.  Listed request handler ('" + handlerClassName + "') does not implement the " + handlerApiClass + " API.");
    }

    private List<RequestHandler> createRequestHandlerChain(String resource, Class<?> handlerApiClass) {
        ArrayList<RequestHandler> handlers = new ArrayList<RequestHandler>();
        BufferedReader reader = null;
        try {
            String requestHandlerClassName;
            InputStream input = this.getClass().getResourceAsStream(resource);
            if (input == null) {
                ArrayList<RequestHandler> arrayList = handlers;
                return arrayList;
            }
            reader = new BufferedReader(new InputStreamReader(input, StringUtils.UTF8));
            while ((requestHandlerClassName = reader.readLine()) != null) {
                RequestHandler requestHandler = this.createRequestHandler(requestHandlerClassName, handlerApiClass);
                if (requestHandler == null) continue;
                handlers.add(requestHandler);
            }
        }
        catch (IOException | ClassNotFoundException | IllegalAccessException | InstantiationException | RuntimeException e) {
            throw new AmazonClientException("Unable to instantiate request handler chain for client: " + e.getMessage(), e);
        }
        finally {
            try {
                if (reader != null) {
                    reader.close();
                }
            }
            catch (IOException iOException) {}
        }
        return handlers;
    }
}

