/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.config;

import java.net.URI;
import java.util.List;
import software.amazon.awssdk.LegacyClientConfiguration;
import software.amazon.awssdk.annotation.ReviewBeforeRelease;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.auth.AwsCredentialsProvider;
import software.amazon.awssdk.client.AwsSyncClientParams;
import software.amazon.awssdk.config.AdvancedClientOption;
import software.amazon.awssdk.config.ImmutableClientConfiguration;
import software.amazon.awssdk.config.SyncClientConfiguration;
import software.amazon.awssdk.handlers.RequestHandler;
import software.amazon.awssdk.http.SdkHttpClient;
import software.amazon.awssdk.metrics.RequestMetricCollector;
import software.amazon.awssdk.runtime.auth.SignerProvider;

@SdkInternalApi
public final class ImmutableSyncClientConfiguration
extends ImmutableClientConfiguration
implements SyncClientConfiguration {
    private final SdkHttpClient sdkHttpClient;

    public ImmutableSyncClientConfiguration(SyncClientConfiguration configuration) {
        super(configuration);
        this.sdkHttpClient = configuration.httpClient();
    }

    @Override
    public SdkHttpClient httpClient() {
        return this.sdkHttpClient;
    }

    @Deprecated
    @ReviewBeforeRelease(value="We should no longer need the client params object by GA.")
    public AwsSyncClientParams asLegacySyncClientParams() {
        return new AwsSyncClientParams(){

            @Override
            public AwsCredentialsProvider getCredentialsProvider() {
                return ImmutableSyncClientConfiguration.this.credentialsProvider();
            }

            @Override
            public LegacyClientConfiguration getClientConfiguration() {
                return ImmutableSyncClientConfiguration.this.asLegacyConfiguration();
            }

            @Override
            public RequestMetricCollector getRequestMetricCollector() {
                return ImmutableSyncClientConfiguration.this.overrideConfiguration().requestMetricCollector();
            }

            @Override
            public List<RequestHandler> getRequestHandlers() {
                return ImmutableSyncClientConfiguration.this.overrideConfiguration().requestListeners();
            }

            @Override
            public SignerProvider getSignerProvider() {
                return ImmutableSyncClientConfiguration.this.overrideConfiguration().advancedOption(AdvancedClientOption.SIGNER_PROVIDER);
            }

            @Override
            public SdkHttpClient sdkHttpClient() {
                return ImmutableSyncClientConfiguration.this.httpClient();
            }

            @Override
            public URI getEndpoint() {
                return ImmutableSyncClientConfiguration.this.endpoint();
            }
        };
    }
}

