/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.config;

import java.net.URI;
import java.util.List;
import java.util.concurrent.ScheduledExecutorService;
import software.amazon.awssdk.LegacyClientConfiguration;
import software.amazon.awssdk.annotation.ReviewBeforeRelease;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.auth.AwsCredentialsProvider;
import software.amazon.awssdk.client.AwsAsyncClientParams;
import software.amazon.awssdk.config.AdvancedClientOption;
import software.amazon.awssdk.config.AsyncClientConfiguration;
import software.amazon.awssdk.config.ImmutableClientConfiguration;
import software.amazon.awssdk.handlers.RequestHandler;
import software.amazon.awssdk.http.SdkHttpClient;
import software.amazon.awssdk.http.async.SdkAsyncHttpClient;
import software.amazon.awssdk.metrics.RequestMetricCollector;
import software.amazon.awssdk.runtime.auth.SignerProvider;

@SdkInternalApi
public final class ImmutableAsyncClientConfiguration
extends ImmutableClientConfiguration
implements AsyncClientConfiguration {
    private final ScheduledExecutorService asyncExecutor;
    private final SdkAsyncHttpClient asyncHttpClient;

    public ImmutableAsyncClientConfiguration(AsyncClientConfiguration configuration) {
        super(configuration);
        this.asyncExecutor = configuration.asyncExecutorService();
        this.asyncHttpClient = configuration.asyncHttpClient();
        this.validate();
    }

    private void validate() {
        this.requireField("asyncExecutorService", this.asyncExecutorService());
    }

    @Override
    public ScheduledExecutorService asyncExecutorService() {
        return this.asyncExecutor;
    }

    @Override
    public SdkAsyncHttpClient asyncHttpClient() {
        return this.asyncHttpClient;
    }

    @Deprecated
    @ReviewBeforeRelease(value="We should no longer need the client params object by GA.")
    public AwsAsyncClientParams asLegacyAsyncClientParams() {
        return new AwsAsyncClientParams(){

            @Override
            public ScheduledExecutorService getExecutor() {
                return ImmutableAsyncClientConfiguration.this.asyncExecutor;
            }

            @Override
            public AwsCredentialsProvider getCredentialsProvider() {
                return ImmutableAsyncClientConfiguration.this.credentialsProvider();
            }

            @Override
            public LegacyClientConfiguration getClientConfiguration() {
                return ImmutableAsyncClientConfiguration.this.asLegacyConfiguration();
            }

            @Override
            public RequestMetricCollector getRequestMetricCollector() {
                return ImmutableAsyncClientConfiguration.this.overrideConfiguration().requestMetricCollector();
            }

            @Override
            public List<RequestHandler> getRequestHandlers() {
                return ImmutableAsyncClientConfiguration.this.overrideConfiguration().requestListeners();
            }

            @Override
            public SignerProvider getSignerProvider() {
                return ImmutableAsyncClientConfiguration.this.overrideConfiguration().advancedOption(AdvancedClientOption.SIGNER_PROVIDER);
            }

            @Override
            public SdkHttpClient sdkHttpClient() {
                throw new UnsupportedOperationException("Sync HTTP client should not be used for async clients");
            }

            @Override
            public SdkAsyncHttpClient getAsyncHttpClient() {
                return ImmutableAsyncClientConfiguration.this.asyncHttpClient();
            }

            @Override
            public URI getEndpoint() {
                return ImmutableAsyncClientConfiguration.this.endpoint();
            }
        };
    }
}

