/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.client.builder;

import java.util.Optional;
import software.amazon.awssdk.annotation.ReviewBeforeRelease;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.http.async.SdkAsyncHttpClient;
import software.amazon.awssdk.http.async.SdkAsyncHttpClientFactory;
import software.amazon.awssdk.utils.Either;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.SdkBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

@ReviewBeforeRelease(value="Do we want this approach to force mutual exclusion or should we flatten it out and do mutex checks at runtime?")
public final class ClientAsyncHttpConfiguration
implements ToCopyableBuilder<Builder, ClientAsyncHttpConfiguration> {
    private final SdkAsyncHttpClient httpClient;
    private final SdkAsyncHttpClientFactory httpClientFactory;

    private ClientAsyncHttpConfiguration(DefaultHttpConfigurationBuilder builder) {
        this.httpClient = builder.httpClient;
        this.httpClientFactory = builder.httpClientFactory;
    }

    public Optional<SdkAsyncHttpClient> httpClient() {
        return Optional.ofNullable(this.httpClient);
    }

    public Optional<SdkAsyncHttpClientFactory> httpClientFactory() {
        return Optional.ofNullable(this.httpClientFactory);
    }

    public Builder toBuilder() {
        return new DefaultHttpConfigurationBuilder().httpClient(this.httpClient).httpClientFactory(this.httpClientFactory);
    }

    @SdkInternalApi
    Optional<Either<SdkAsyncHttpClient, SdkAsyncHttpClientFactory>> toEither() {
        if (this.httpClient != null) {
            return Optional.of(Either.left((Object)this.httpClient));
        }
        if (this.httpClientFactory != null) {
            return Optional.of(Either.right((Object)this.httpClientFactory));
        }
        return Optional.empty();
    }

    public static Builder builder() {
        return new DefaultHttpConfigurationBuilder();
    }

    private static final class DefaultHttpConfigurationBuilder
    implements Builder {
        private SdkAsyncHttpClient httpClient;
        private SdkAsyncHttpClientFactory httpClientFactory;

        private DefaultHttpConfigurationBuilder() {
        }

        public DefaultHttpConfigurationBuilder httpClient(SdkAsyncHttpClient sdkHttpClient) {
            this.httpClient = sdkHttpClient;
            return this;
        }

        public void setHttpClient(SdkAsyncHttpClient httpClient) {
            this.httpClient = httpClient;
        }

        public DefaultHttpConfigurationBuilder httpClientFactory(SdkAsyncHttpClientFactory sdkClientFactory) {
            this.httpClientFactory = sdkClientFactory;
            return this;
        }

        public void setHttpClientFactory(SdkAsyncHttpClientFactory httpClientFactory) {
            this.httpClientFactory = httpClientFactory;
        }

        public ClientAsyncHttpConfiguration build() {
            return new ClientAsyncHttpConfiguration(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ClientAsyncHttpConfiguration> {
        public SdkBuilder<?, ClientAsyncHttpConfiguration> httpClient(SdkAsyncHttpClient var1);

        public SdkBuilder<?, ClientAsyncHttpConfiguration> httpClientFactory(SdkAsyncHttpClientFactory var1);
    }
}

