/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.auth.profile;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.auth.AwsCredentials;
import software.amazon.awssdk.auth.AwsCredentialsProvider;
import software.amazon.awssdk.auth.StaticCredentialsProvider;
import software.amazon.awssdk.auth.profile.internal.AllProfiles;
import software.amazon.awssdk.auth.profile.internal.BasicProfile;
import software.amazon.awssdk.auth.profile.internal.BasicProfileConfigLoader;
import software.amazon.awssdk.auth.profile.internal.Profile;
import software.amazon.awssdk.auth.profile.internal.ProfileAssumeRoleCredentialsProvider;
import software.amazon.awssdk.auth.profile.internal.ProfileStaticCredentialsProvider;
import software.amazon.awssdk.auth.profile.internal.securitytoken.ProfileCredentialsService;
import software.amazon.awssdk.auth.profile.internal.securitytoken.StsProfileCredentialsServiceLoader;
import software.amazon.awssdk.profile.path.AwsProfileFileLocationProvider;
import software.amazon.awssdk.util.ValidationUtils;

public class ProfilesConfigFile {
    private final File profileFile;
    private final ProfileCredentialsService profileCredentialsService;
    private final ConcurrentHashMap<String, AwsCredentialsProvider> credentialProviderCache = new ConcurrentHashMap();
    private volatile AllProfiles allProfiles;
    private volatile long profileFileLastModified;

    public ProfilesConfigFile() throws SdkClientException {
        this(ProfilesConfigFile.getCredentialProfilesFile());
    }

    public ProfilesConfigFile(String filePath) {
        this(new File(ProfilesConfigFile.validateFilePath(filePath)));
    }

    public ProfilesConfigFile(String filePath, ProfileCredentialsService credentialsService) throws SdkClientException {
        this(new File(ProfilesConfigFile.validateFilePath(filePath)), credentialsService);
    }

    public ProfilesConfigFile(File file) throws SdkClientException {
        this(file, (ProfileCredentialsService)StsProfileCredentialsServiceLoader.getInstance());
    }

    public ProfilesConfigFile(File file, ProfileCredentialsService credentialsService) throws SdkClientException {
        this.profileFile = ValidationUtils.assertNotNull(file, "profile file");
        this.profileCredentialsService = credentialsService;
        this.profileFileLastModified = file.lastModified();
        this.allProfiles = ProfilesConfigFile.loadProfiles(this.profileFile);
    }

    private static String validateFilePath(String filePath) {
        if (filePath == null) {
            throw new IllegalArgumentException("Unable to load AWS profiles: specified file path is null.");
        }
        return filePath;
    }

    private static File getCredentialProfilesFile() {
        return AwsProfileFileLocationProvider.DEFAULT_CREDENTIALS_LOCATION_PROVIDER.getLocation();
    }

    private static AllProfiles loadProfiles(File file) {
        return BasicProfileConfigLoader.INSTANCE.loadProfiles(file);
    }

    public AwsCredentials getCredentials(String profileName) {
        AwsCredentialsProvider provider = this.credentialProviderCache.get(profileName);
        if (provider != null) {
            return provider.getCredentials();
        }
        BasicProfile profile = this.allProfiles.getProfile(profileName);
        if (profile == null) {
            throw new IllegalArgumentException("No AWS profile named '" + profileName + "'");
        }
        AwsCredentialsProvider newProvider = this.fromProfile(profile);
        this.credentialProviderCache.put(profileName, newProvider);
        return newProvider.getCredentials();
    }

    public void refresh() {
        if (this.profileFile.lastModified() > this.profileFileLastModified) {
            this.profileFileLastModified = this.profileFile.lastModified();
            this.allProfiles = ProfilesConfigFile.loadProfiles(this.profileFile);
        }
        this.credentialProviderCache.clear();
    }

    public Map<String, BasicProfile> getAllBasicProfiles() {
        return this.allProfiles.getProfiles();
    }

    @Deprecated
    public Map<String, Profile> getAllProfiles() {
        HashMap<String, Profile> legacyProfiles = new HashMap<String, Profile>();
        for (Map.Entry<String, BasicProfile> entry : this.getAllBasicProfiles().entrySet()) {
            String profileName = entry.getKey();
            legacyProfiles.put(profileName, new Profile(profileName, entry.getValue().getProperties(), new StaticCredentialsProvider(this.getCredentials(profileName))));
        }
        return legacyProfiles;
    }

    private AwsCredentialsProvider fromProfile(BasicProfile profile) {
        if (profile.isRoleBasedProfile()) {
            return new ProfileAssumeRoleCredentialsProvider(this.profileCredentialsService, this.allProfiles, profile);
        }
        return new ProfileStaticCredentialsProvider(profile);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "(" + this.profileFile + ")";
    }
}

