/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.auth.internal;

import java.util.Date;
import software.amazon.awssdk.annotation.ReviewBeforeRelease;
import software.amazon.awssdk.auth.internal.Aws4SignerUtils;
import software.amazon.awssdk.handlers.AwsHandlerKeys;
import software.amazon.awssdk.http.SdkHttpRequest;
import software.amazon.awssdk.util.AwsHostNameUtils;

public final class Aws4SignerRequestParams {
    private final SdkHttpRequest request;
    private final long signingDateTimeMilli;
    private final String scope;
    private final String regionName;
    private final String serviceName;
    private final String formattedSigningDateTime;
    private final String formattedSigningDate;
    private final String signingAlgorithm;

    public Aws4SignerRequestParams(SdkHttpRequest request, Date signingDateOverride, String regionNameOverride, String serviceName, String signingAlgorithm) {
        if (request == null) {
            throw new IllegalArgumentException("Request cannot be null");
        }
        if (signingAlgorithm == null) {
            throw new IllegalArgumentException("Signing Algorithm cannot be null");
        }
        this.request = request;
        this.signingDateTimeMilli = signingDateOverride != null ? signingDateOverride.getTime() : this.getSigningDate(request);
        this.formattedSigningDate = Aws4SignerUtils.formatDateStamp(this.signingDateTimeMilli);
        this.serviceName = serviceName;
        this.regionName = this.parseRegion(request, regionNameOverride);
        this.scope = this.generateScope(this.formattedSigningDate, this.serviceName, this.regionName);
        this.formattedSigningDateTime = Aws4SignerUtils.formatTimestamp(this.signingDateTimeMilli);
        this.signingAlgorithm = signingAlgorithm;
    }

    @ReviewBeforeRelease(value="Specify region when creating signer rather then parsing from endpoint.")
    private String parseRegion(SdkHttpRequest request, String regionNameOverride) {
        return regionNameOverride != null ? regionNameOverride : AwsHostNameUtils.parseRegionName(request.getEndpoint().getHost(), this.serviceName);
    }

    private long getSigningDate(SdkHttpRequest request) {
        if (request.handlerContext(AwsHandlerKeys.TIME_OFFSET) == null) {
            return System.currentTimeMillis();
        }
        return System.currentTimeMillis() - (long)((Integer)request.handlerContext(AwsHandlerKeys.TIME_OFFSET)).intValue() * 1000L;
    }

    private String generateScope(String dateStamp, String serviceName, String regionName) {
        return dateStamp + "/" + regionName + "/" + serviceName + "/" + "aws4_request";
    }

    public SdkHttpRequest getRequest() {
        return this.request;
    }

    public String getScope() {
        return this.scope;
    }

    public String getFormattedSigningDateTime() {
        return this.formattedSigningDateTime;
    }

    public long getSigningDateTimeMilli() {
        return this.signingDateTimeMilli;
    }

    public String getRegionName() {
        return this.regionName;
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public String getFormattedSigningDate() {
        return this.formattedSigningDate;
    }

    public String getSigningAlgorithm() {
        return this.signingAlgorithm;
    }
}

