/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.async;

import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.ByteBuffer;
import java.nio.channels.AsynchronousFileChannel;
import java.nio.channels.CompletionHandler;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.concurrent.atomic.AtomicLong;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.async.AsyncRequestProvider;

@SdkInternalApi
class FileAsyncRequestProvider
implements AsyncRequestProvider {
    private static final int CHUNK_SIZE = 1024;
    private final File file;

    FileAsyncRequestProvider(Path path) {
        this.file = path.toFile();
    }

    @Override
    public long contentLength() {
        return this.file.length();
    }

    public void subscribe(Subscriber<? super ByteBuffer> s) {
        s.onSubscribe((Subscription)new FileSubscription(this.file, s));
    }

    private static AsynchronousFileChannel openInputChannel(File file) {
        try {
            Path path = Paths.get(file.getAbsolutePath(), new String[0]);
            if (!Files.exists(path, new LinkOption[0])) {
                Files.createFile(path, new FileAttribute[0]);
            }
            return AsynchronousFileChannel.open(path, StandardOpenOption.READ);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private static class FileSubscription
    implements Subscription {
        private final AsynchronousFileChannel inputChannel;
        private final Subscriber<? super ByteBuffer> subscriber;
        private long position = 0L;
        private AtomicLong outstandingRequests = new AtomicLong(0L);
        private boolean writeInProgress = false;

        private FileSubscription(File file, Subscriber<? super ByteBuffer> subscriber) {
            this.inputChannel = FileAsyncRequestProvider.openInputChannel(file);
            this.subscriber = subscriber;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void request(long n) {
            this.outstandingRequests.addAndGet(n);
            FileSubscription fileSubscription = this;
            synchronized (fileSubscription) {
                if (!this.writeInProgress) {
                    this.writeInProgress = true;
                    this.readData();
                }
            }
        }

        public void cancel() {
            this.closeFile();
        }

        private void readData() {
            ByteBuffer buffer = ByteBuffer.allocate(1024);
            this.inputChannel.read(buffer, this.position, buffer, new CompletionHandler<Integer, ByteBuffer>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void completed(Integer result, ByteBuffer attachment) {
                    if (result > 0) {
                        attachment.flip();
                        position = position + (long)attachment.remaining();
                        subscriber.onNext((Object)attachment);
                        if (outstandingRequests.decrementAndGet() > 0L) {
                            this.readData();
                            return;
                        }
                    } else {
                        subscriber.onComplete();
                        this.closeFile();
                    }
                    FileSubscription fileSubscription = this;
                    synchronized (fileSubscription) {
                        writeInProgress = false;
                    }
                }

                @Override
                public void failed(Throwable exc, ByteBuffer attachment) {
                    subscriber.onError(exc);
                    this.closeFile();
                }
            });
        }

        private void closeFile() {
            try {
                this.inputChannel.close();
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }
    }
}

