/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import software.amazon.awssdk.Protocol;
import software.amazon.awssdk.annotation.NotThreadSafe;
import software.amazon.awssdk.retry.PredefinedRetryPolicies;
import software.amazon.awssdk.retry.RetryPolicy;
import software.amazon.awssdk.util.ValidationUtils;
import software.amazon.awssdk.util.VersionInfoUtils;

@Deprecated
@NotThreadSafe
public class LegacyClientConfiguration {
    public static final int DEFAULT_CLIENT_EXECUTION_TIMEOUT = 0;
    public static final int DEFAULT_MAX_CONNECTIONS = 50;
    public static final String DEFAULT_USER_AGENT = VersionInfoUtils.getUserAgent();
    public static final RetryPolicy DEFAULT_RETRY_POLICY = PredefinedRetryPolicies.DEFAULT;
    public static final boolean DEFAULT_USE_GZIP = false;
    public static final boolean DEFAULT_THROTTLE_RETRIES = true;
    public static final int DEFAULT_MAX_CONSECUTIVE_RETRIES_BEFORE_THROTTLING = 100;
    private String userAgentPrefix = DEFAULT_USER_AGENT;
    private String userAgentSuffix;
    private int maxErrorRetry = -1;
    private RetryPolicy retryPolicy = DEFAULT_RETRY_POLICY;
    private Protocol protocol = Protocol.HTTPS;
    private int maxConnections = 50;
    private int clientExecutionTimeout = 0;
    private boolean throttleRetries = true;
    private boolean useGzip = false;
    private String signerOverride;
    private Map<String, String> headers = new HashMap<String, String>();
    private int maxConsecutiveRetriesBeforeThrottling = 100;

    public LegacyClientConfiguration() {
    }

    public LegacyClientConfiguration(LegacyClientConfiguration other) {
        this.maxConnections = other.maxConnections;
        this.maxErrorRetry = other.maxErrorRetry;
        this.retryPolicy = other.retryPolicy;
        this.throttleRetries = other.throttleRetries;
        this.protocol = other.protocol;
        this.clientExecutionTimeout = other.clientExecutionTimeout;
        this.userAgentPrefix = other.userAgentPrefix;
        this.userAgentSuffix = other.userAgentSuffix;
        this.useGzip = other.useGzip;
        this.signerOverride = other.signerOverride;
        this.headers.clear();
        this.headers.putAll(other.headers);
        this.maxConsecutiveRetriesBeforeThrottling = other.maxConsecutiveRetriesBeforeThrottling;
    }

    public Protocol getProtocol() {
        return this.protocol;
    }

    public void setProtocol(Protocol protocol) {
        this.protocol = protocol;
    }

    public LegacyClientConfiguration withProtocol(Protocol protocol) {
        this.setProtocol(protocol);
        return this;
    }

    @Deprecated
    public String getUserAgent() {
        return this.getUserAgentPrefix();
    }

    @Deprecated
    public void setUserAgent(String userAgent) {
        this.setUserAgentPrefix(userAgent);
    }

    @Deprecated
    public LegacyClientConfiguration withUserAgent(String userAgent) {
        return this.withUserAgentPrefix(userAgent);
    }

    public String getUserAgentPrefix() {
        return this.userAgentPrefix;
    }

    public void setUserAgentPrefix(String prefix) {
        this.userAgentPrefix = prefix;
    }

    public LegacyClientConfiguration withUserAgentPrefix(String prefix) {
        this.setUserAgentPrefix(prefix);
        return this;
    }

    public String getUserAgentSuffix() {
        return this.userAgentSuffix;
    }

    public void setUserAgentSuffix(String suffix) {
        this.userAgentSuffix = suffix;
    }

    public LegacyClientConfiguration withUserAgentSuffix(String suffix) {
        this.setUserAgentSuffix(suffix);
        return this;
    }

    public RetryPolicy getRetryPolicy() {
        return this.retryPolicy;
    }

    public void setRetryPolicy(RetryPolicy retryPolicy) {
        this.retryPolicy = retryPolicy;
    }

    public LegacyClientConfiguration withRetryPolicy(RetryPolicy retryPolicy) {
        this.setRetryPolicy(retryPolicy);
        return this;
    }

    public int getMaxErrorRetry() {
        return this.maxErrorRetry;
    }

    public void setMaxErrorRetry(int maxErrorRetry) {
        if (maxErrorRetry < 0) {
            throw new IllegalArgumentException("maxErrorRetry shoud be non-negative");
        }
        this.maxErrorRetry = maxErrorRetry;
    }

    public LegacyClientConfiguration withMaxErrorRetry(int maxErrorRetry) {
        this.setMaxErrorRetry(maxErrorRetry);
        return this;
    }

    public int getClientExecutionTimeout() {
        return this.clientExecutionTimeout;
    }

    public void setClientExecutionTimeout(int clientExecutionTimeout) {
        this.clientExecutionTimeout = clientExecutionTimeout;
    }

    public LegacyClientConfiguration withClientExecutionTimeout(int clientExecutionTimeout) {
        this.setClientExecutionTimeout(clientExecutionTimeout);
        return this;
    }

    public boolean useThrottledRetries() {
        return this.throttleRetries;
    }

    public void setUseThrottleRetries(boolean use) {
        this.throttleRetries = use;
    }

    public LegacyClientConfiguration withThrottledRetries(boolean use) {
        this.setUseThrottleRetries(use);
        return this;
    }

    public void setMaxConsecutiveRetriesBeforeThrottling(int maxConsecutiveRetriesBeforeThrottling) {
        this.maxConsecutiveRetriesBeforeThrottling = ValidationUtils.assertIsPositive(maxConsecutiveRetriesBeforeThrottling, "maxConsecutiveRetriesBeforeThrottling");
    }

    public LegacyClientConfiguration withMaxConsecutiveRetriesBeforeThrottling(int maxConsecutiveRetriesBeforeThrottling) {
        this.setMaxConsecutiveRetriesBeforeThrottling(maxConsecutiveRetriesBeforeThrottling);
        return this;
    }

    public int getMaxConsecutiveRetriesBeforeThrottling() {
        return this.maxConsecutiveRetriesBeforeThrottling;
    }

    public boolean useGzip() {
        return this.useGzip;
    }

    public void setUseGzip(boolean use) {
        this.useGzip = use;
    }

    public LegacyClientConfiguration withGzip(boolean use) {
        this.setUseGzip(use);
        return this;
    }

    public String getSignerOverride() {
        return this.signerOverride;
    }

    public void setSignerOverride(String value) {
        this.signerOverride = value;
    }

    public LegacyClientConfiguration withSignerOverride(String value) {
        this.setSignerOverride(value);
        return this;
    }

    public LegacyClientConfiguration withHeader(String name, String value) {
        this.addHeader(name, value);
        return this;
    }

    public void addHeader(String name, String value) {
        this.headers.put(name, value);
    }

    public Map<String, String> getHeaders() {
        return Collections.unmodifiableMap(this.headers);
    }
}

