/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.waiters;

import java.util.ArrayList;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.annotation.SdkProtectedApi;
import software.amazon.awssdk.waiters.PollingStrategy;
import software.amazon.awssdk.waiters.SdkFunction;
import software.amazon.awssdk.waiters.WaiterAcceptor;
import software.amazon.awssdk.waiters.WaiterExecution;

@SdkProtectedApi
public class WaiterExecutionBuilder<InputT extends AmazonWebServiceRequest, OutputT> {
    private SdkFunction<InputT, OutputT> sdkFunction;
    private InputT request;
    private PollingStrategy pollingStrategy;
    private List<WaiterAcceptor<OutputT>> acceptors = new ArrayList<WaiterAcceptor<OutputT>>();

    public WaiterExecutionBuilder<InputT, OutputT> withSdkFunction(SdkFunction sdkFunction) {
        this.sdkFunction = sdkFunction;
        return this;
    }

    public WaiterExecutionBuilder<InputT, OutputT> withRequest(InputT request) {
        this.request = request;
        return this;
    }

    public WaiterExecutionBuilder<InputT, OutputT> withPollingStrategy(PollingStrategy pollingStrategy) {
        this.pollingStrategy = pollingStrategy;
        return this;
    }

    public WaiterExecutionBuilder<InputT, OutputT> withAcceptors(List<WaiterAcceptor<OutputT>> acceptors) {
        this.acceptors = acceptors;
        return this;
    }

    public InputT getRequest() {
        return this.request;
    }

    public List<WaiterAcceptor<OutputT>> getAcceptorsList() {
        return this.acceptors;
    }

    public SdkFunction<InputT, OutputT> getSdkFunction() {
        return this.sdkFunction;
    }

    public PollingStrategy getPollingStrategy() {
        return this.pollingStrategy;
    }

    public WaiterExecution<InputT, OutputT> build() {
        return new WaiterExecution(this);
    }
}

