/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.waiters;

import java.util.ArrayList;
import java.util.List;
import software.amazon.awssdk.AmazonServiceException;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.util.ValidationUtils;
import software.amazon.awssdk.waiters.WaiterAcceptor;
import software.amazon.awssdk.waiters.WaiterState;

@SdkInternalApi
class CompositeAcceptor<OutputT> {
    private List<WaiterAcceptor<OutputT>> acceptors = new ArrayList<WaiterAcceptor<OutputT>>();

    public CompositeAcceptor(List<WaiterAcceptor<OutputT>> acceptors) {
        this.acceptors = ValidationUtils.assertNotEmpty(acceptors, "acceptors");
    }

    public List<WaiterAcceptor<OutputT>> getAcceptors() {
        return this.acceptors;
    }

    public WaiterState accepts(OutputT response) {
        for (WaiterAcceptor<OutputT> acceptor : this.acceptors) {
            if (!acceptor.matches(response)) continue;
            return acceptor.getState();
        }
        return WaiterState.RETRY;
    }

    public WaiterState accepts(AmazonServiceException exception) throws AmazonServiceException {
        for (WaiterAcceptor<OutputT> acceptor : this.acceptors) {
            if (!acceptor.matches(exception)) continue;
            return acceptor.getState();
        }
        throw exception;
    }
}

