/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.runtime.transform;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.util.Date;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.runtime.transform.SimpleTypeUnmarshallers;
import software.amazon.awssdk.runtime.transform.StaxUnmarshallerContext;
import software.amazon.awssdk.runtime.transform.Unmarshaller;
import software.amazon.awssdk.util.DateUtils;
import software.amazon.awssdk.utils.Base64Utils;

public class SimpleTypeStaxUnmarshallers {
    private static Log log = LogFactory.getLog(SimpleTypeUnmarshallers.class);

    public static class ShortJsonUnmarshaller
    implements Unmarshaller<Short, StaxUnmarshallerContext> {
        private static final ShortJsonUnmarshaller INSTANCE = new ShortJsonUnmarshaller();

        public static ShortJsonUnmarshaller getInstance() {
            return INSTANCE;
        }

        @Override
        public Short unmarshall(StaxUnmarshallerContext unmarshallerContext) throws Exception {
            String shortString = unmarshallerContext.readText();
            return shortString == null ? null : Short.valueOf(shortString);
        }
    }

    public static class CharacterJsonUnmarshaller
    implements Unmarshaller<Character, StaxUnmarshallerContext> {
        private static final CharacterJsonUnmarshaller INSTANCE = new CharacterJsonUnmarshaller();

        public static CharacterJsonUnmarshaller getInstance() {
            return INSTANCE;
        }

        @Override
        public Character unmarshall(StaxUnmarshallerContext unmarshallerContext) throws Exception {
            String charString = unmarshallerContext.readText();
            if (charString == null) {
                return null;
            }
            if ((charString = charString.trim()).isEmpty() || charString.length() > 1) {
                throw new SdkClientException("'" + charString + "' cannot be converted to Character");
            }
            return Character.valueOf(charString.charAt(0));
        }
    }

    public static class ByteBufferUnmarshaller
    implements Unmarshaller<ByteBuffer, StaxUnmarshallerContext> {
        private static final ByteBufferUnmarshaller INSTANCE = new ByteBufferUnmarshaller();

        public static ByteBufferUnmarshaller getInstance() {
            return INSTANCE;
        }

        @Override
        public ByteBuffer unmarshall(StaxUnmarshallerContext unmarshallerContext) throws Exception {
            String base64EncodedString = unmarshallerContext.readText();
            byte[] decodedBytes = Base64Utils.decode((String)base64EncodedString);
            return ByteBuffer.wrap(decodedBytes);
        }
    }

    public static class DateUnmarshaller
    implements Unmarshaller<Date, StaxUnmarshallerContext> {
        private static final DateUnmarshaller INSTANCE = new DateUnmarshaller();

        public static DateUnmarshaller getInstance() {
            return INSTANCE;
        }

        @Override
        public Date unmarshall(StaxUnmarshallerContext unmarshallerContext) throws Exception {
            String dateString = unmarshallerContext.readText();
            if (dateString == null) {
                return null;
            }
            try {
                return DateUtils.parseIso8601Date(dateString);
            }
            catch (Exception e) {
                log.warn((Object)("Unable to parse date '" + dateString + "':  " + e.getMessage()), (Throwable)e);
                return null;
            }
        }
    }

    public static class ByteUnmarshaller
    implements Unmarshaller<Byte, StaxUnmarshallerContext> {
        private static final ByteUnmarshaller INSTANCE = new ByteUnmarshaller();

        public static ByteUnmarshaller getInstance() {
            return INSTANCE;
        }

        @Override
        public Byte unmarshall(StaxUnmarshallerContext unmarshallerContext) throws Exception {
            String byteString = unmarshallerContext.readText();
            return byteString == null ? null : Byte.valueOf(byteString);
        }
    }

    public static class LongUnmarshaller
    implements Unmarshaller<Long, StaxUnmarshallerContext> {
        private static final LongUnmarshaller INSTANCE = new LongUnmarshaller();

        public static LongUnmarshaller getInstance() {
            return INSTANCE;
        }

        @Override
        public Long unmarshall(StaxUnmarshallerContext unmarshallerContext) throws Exception {
            String longString = unmarshallerContext.readText();
            return longString == null ? null : Long.valueOf(Long.parseLong(longString));
        }
    }

    public static class FloatUnmarshaller
    implements Unmarshaller<Float, StaxUnmarshallerContext> {
        private static final FloatUnmarshaller INSTANCE = new FloatUnmarshaller();

        public static FloatUnmarshaller getInstance() {
            return INSTANCE;
        }

        @Override
        public Float unmarshall(StaxUnmarshallerContext unmarshallerContext) throws Exception {
            String floatString = unmarshallerContext.readText();
            return floatString == null ? null : Float.valueOf(floatString);
        }
    }

    public static class BooleanUnmarshaller
    implements Unmarshaller<Boolean, StaxUnmarshallerContext> {
        private static final BooleanUnmarshaller INSTANCE = new BooleanUnmarshaller();

        public static BooleanUnmarshaller getInstance() {
            return INSTANCE;
        }

        @Override
        public Boolean unmarshall(StaxUnmarshallerContext unmarshallerContext) throws Exception {
            String booleanString = unmarshallerContext.readText();
            return booleanString == null ? null : Boolean.valueOf(Boolean.parseBoolean(booleanString));
        }
    }

    public static class IntegerUnmarshaller
    implements Unmarshaller<Integer, StaxUnmarshallerContext> {
        private static final IntegerUnmarshaller INSTANCE = new IntegerUnmarshaller();

        public static IntegerUnmarshaller getInstance() {
            return INSTANCE;
        }

        @Override
        public Integer unmarshall(StaxUnmarshallerContext unmarshallerContext) throws Exception {
            String intString = unmarshallerContext.readText();
            return intString == null ? null : Integer.valueOf(Integer.parseInt(intString));
        }
    }

    public static class DoubleUnmarshaller
    implements Unmarshaller<Double, StaxUnmarshallerContext> {
        private static final DoubleUnmarshaller INSTANCE = new DoubleUnmarshaller();

        public static DoubleUnmarshaller getInstance() {
            return INSTANCE;
        }

        @Override
        public Double unmarshall(StaxUnmarshallerContext unmarshallerContext) throws Exception {
            String doubleString = unmarshallerContext.readText();
            return doubleString == null ? null : Double.valueOf(Double.parseDouble(doubleString));
        }
    }

    public static class BigIntegerUnmarshaller
    implements Unmarshaller<BigInteger, StaxUnmarshallerContext> {
        private static final BigIntegerUnmarshaller INSTANCE = new BigIntegerUnmarshaller();

        public static BigIntegerUnmarshaller getInstance() {
            return INSTANCE;
        }

        @Override
        public BigInteger unmarshall(StaxUnmarshallerContext unmarshallerContext) throws Exception {
            String s = unmarshallerContext.readText();
            return s == null ? null : new BigInteger(s);
        }
    }

    public static class BigDecimalUnmarshaller
    implements Unmarshaller<BigDecimal, StaxUnmarshallerContext> {
        private static final BigDecimalUnmarshaller INSTANCE = new BigDecimalUnmarshaller();

        public static BigDecimalUnmarshaller getInstance() {
            return INSTANCE;
        }

        @Override
        public BigDecimal unmarshall(StaxUnmarshallerContext unmarshallerContext) throws Exception {
            String s = unmarshallerContext.readText();
            return s == null ? null : new BigDecimal(s);
        }
    }

    public static class StringUnmarshaller
    implements Unmarshaller<String, StaxUnmarshallerContext> {
        private static final StringUnmarshaller INSTANCE = new StringUnmarshaller();

        public static StringUnmarshaller getInstance() {
            return INSTANCE;
        }

        @Override
        public String unmarshall(StaxUnmarshallerContext unmarshallerContext) throws Exception {
            return unmarshallerContext.readText();
        }
    }
}

