/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.runtime.io;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import software.amazon.awssdk.AbortedException;
import software.amazon.awssdk.annotation.SdkProtectedApi;
import software.amazon.awssdk.internal.io.Releasable;
import software.amazon.awssdk.internal.io.SdkIoUtils;
import software.amazon.awssdk.runtime.MetricAware;
import software.amazon.awssdk.util.SdkRuntime;

@SdkProtectedApi
public class SdkFilterInputStream
extends FilterInputStream
implements MetricAware,
Releasable {
    protected SdkFilterInputStream(InputStream in) {
        super(in);
    }

    @Override
    public boolean isMetricActivated() {
        if (this.in instanceof MetricAware) {
            MetricAware metricAware = (MetricAware)((Object)this.in);
            return metricAware.isMetricActivated();
        }
        return false;
    }

    protected final void abortIfNeeded() {
        if (SdkRuntime.shouldAbort()) {
            this.abort();
            throw new AbortedException();
        }
    }

    protected void abort() {
    }

    @Override
    public int read() throws IOException {
        this.abortIfNeeded();
        return this.in.read();
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        this.abortIfNeeded();
        return this.in.read(b, off, len);
    }

    @Override
    public long skip(long n) throws IOException {
        this.abortIfNeeded();
        return this.in.skip(n);
    }

    @Override
    public int available() throws IOException {
        this.abortIfNeeded();
        return this.in.available();
    }

    @Override
    public void close() throws IOException {
        this.in.close();
        this.abortIfNeeded();
    }

    @Override
    public synchronized void mark(int readlimit) {
        this.abortIfNeeded();
        this.in.mark(readlimit);
    }

    @Override
    public synchronized void reset() throws IOException {
        this.abortIfNeeded();
        this.in.reset();
    }

    @Override
    public boolean markSupported() {
        this.abortIfNeeded();
        return this.in.markSupported();
    }

    @Override
    public void release() {
        SdkIoUtils.closeQuietly(this);
        if (this.in instanceof Releasable) {
            Releasable r = (Releasable)((Object)this.in);
            r.release();
        }
    }
}

