/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.retry;

import java.util.HashSet;
import java.util.Set;
import software.amazon.awssdk.AmazonServiceException;
import software.amazon.awssdk.SdkBaseException;

public class RetryUtils {
    static final Set<String> THROTTLING_ERROR_CODES = new HashSet<String>(9);
    static final Set<String> CLOCK_SKEW_ERROR_CODES = new HashSet<String>(6);
    static final Set<Integer> RETRYABLE_STATUS_CODES = new HashSet<Integer>(4);

    public static boolean isRetryableServiceException(SdkBaseException exception) {
        return RetryUtils.isAse(exception) && RETRYABLE_STATUS_CODES.contains(RetryUtils.toAse(exception).getStatusCode());
    }

    @Deprecated
    public static boolean isThrottlingException(AmazonServiceException exception) {
        return RetryUtils.isThrottlingException((SdkBaseException)exception);
    }

    public static boolean isThrottlingException(SdkBaseException exception) {
        return RetryUtils.isAse(exception) && THROTTLING_ERROR_CODES.contains(RetryUtils.toAse(exception).getErrorCode());
    }

    public static boolean isRequestEntityTooLargeException(SdkBaseException exception) {
        return RetryUtils.isAse(exception) && RetryUtils.toAse(exception).getStatusCode() == 413;
    }

    public static boolean isClockSkewError(SdkBaseException exception) {
        return RetryUtils.isAse(exception) && CLOCK_SKEW_ERROR_CODES.contains(RetryUtils.toAse(exception).getErrorCode());
    }

    private static boolean isAse(SdkBaseException e) {
        return e instanceof AmazonServiceException;
    }

    private static AmazonServiceException toAse(SdkBaseException e) {
        if (!(e instanceof AmazonServiceException)) {
            throw new IllegalStateException("Received non-AmazonServiceException where one was expected.", e);
        }
        return (AmazonServiceException)e;
    }

    static {
        THROTTLING_ERROR_CODES.add("Throttling");
        THROTTLING_ERROR_CODES.add("ThrottlingException");
        THROTTLING_ERROR_CODES.add("ProvisionedThroughputExceededException");
        THROTTLING_ERROR_CODES.add("SlowDown");
        THROTTLING_ERROR_CODES.add("TooManyRequestsException");
        THROTTLING_ERROR_CODES.add("RequestLimitExceeded");
        THROTTLING_ERROR_CODES.add("BandwidthLimitExceeded");
        THROTTLING_ERROR_CODES.add("RequestThrottled");
        CLOCK_SKEW_ERROR_CODES.add("RequestTimeTooSkewed");
        CLOCK_SKEW_ERROR_CODES.add("RequestExpired");
        CLOCK_SKEW_ERROR_CODES.add("InvalidSignatureException");
        CLOCK_SKEW_ERROR_CODES.add("SignatureDoesNotMatch");
        CLOCK_SKEW_ERROR_CODES.add("AuthFailure");
        CLOCK_SKEW_ERROR_CODES.add("RequestInTheFuture");
        RETRYABLE_STATUS_CODES.add(500);
        RETRYABLE_STATUS_CODES.add(502);
        RETRYABLE_STATUS_CODES.add(503);
        RETRYABLE_STATUS_CODES.add(504);
    }
}

