/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.protocol.json.internal;

import java.math.BigDecimal;
import java.nio.ByteBuffer;
import java.util.Date;
import java.util.List;
import java.util.Map;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.MarshallLocation;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.protocol.json.StructuredJsonGenerator;
import software.amazon.awssdk.protocol.json.internal.JsonMarshaller;
import software.amazon.awssdk.protocol.json.internal.JsonMarshallerContext;
import software.amazon.awssdk.runtime.SdkInternalList;
import software.amazon.awssdk.runtime.SdkInternalMap;

@SdkInternalApi
public class SimpleTypeJsonMarshallers {
    public static final JsonMarshaller<Void> NULL = (val, context, paramName) -> {
        if (paramName == null) {
            context.jsonGenerator().writeNull();
        }
    };
    public static final JsonMarshaller<String> STRING = new BaseJsonMarshaller<String>(){

        @Override
        public void marshall(String val, StructuredJsonGenerator jsonGenerator, JsonMarshallerContext context) {
            jsonGenerator.writeValue(val);
        }
    };
    public static final JsonMarshaller<Integer> INTEGER = new BaseJsonMarshaller<Integer>(){

        @Override
        public void marshall(Integer val, StructuredJsonGenerator jsonGenerator, JsonMarshallerContext context) {
            jsonGenerator.writeValue(val);
        }
    };
    public static final JsonMarshaller<Long> LONG = new BaseJsonMarshaller<Long>(){

        @Override
        public void marshall(Long val, StructuredJsonGenerator jsonGenerator, JsonMarshallerContext context) {
            jsonGenerator.writeValue(val);
        }
    };
    public static final JsonMarshaller<Float> FLOAT = new BaseJsonMarshaller<Float>(){

        @Override
        public void marshall(Float val, StructuredJsonGenerator jsonGenerator, JsonMarshallerContext context) {
            jsonGenerator.writeValue(val.floatValue());
        }
    };
    public static final JsonMarshaller<BigDecimal> BIG_DECIMAL = new BaseJsonMarshaller<BigDecimal>(){

        @Override
        public void marshall(BigDecimal val, StructuredJsonGenerator jsonGenerator, JsonMarshallerContext context) {
            jsonGenerator.writeValue(val);
        }
    };
    public static final JsonMarshaller<Double> DOUBLE = new BaseJsonMarshaller<Double>(){

        @Override
        public void marshall(Double val, StructuredJsonGenerator jsonGenerator, JsonMarshallerContext context) {
            jsonGenerator.writeValue(val);
        }
    };
    public static final JsonMarshaller<Boolean> BOOLEAN = new BaseJsonMarshaller<Boolean>(){

        @Override
        public void marshall(Boolean val, StructuredJsonGenerator jsonGenerator, JsonMarshallerContext context) {
            jsonGenerator.writeValue(val);
        }
    };
    public static final JsonMarshaller<Date> DATE = new BaseJsonMarshaller<Date>(){

        @Override
        public void marshall(Date val, StructuredJsonGenerator jsonGenerator, JsonMarshallerContext context) {
            jsonGenerator.writeValue(val);
        }
    };
    public static final JsonMarshaller<ByteBuffer> BYTE_BUFFER = new BaseJsonMarshaller<ByteBuffer>(){

        @Override
        public void marshall(ByteBuffer val, StructuredJsonGenerator jsonGenerator, JsonMarshallerContext context) {
            jsonGenerator.writeValue(val);
        }
    };
    public static final JsonMarshaller<StructuredPojo> STRUCTURED = new BaseJsonMarshaller<StructuredPojo>(){

        @Override
        public void marshall(StructuredPojo val, StructuredJsonGenerator jsonGenerator, JsonMarshallerContext context) {
            jsonGenerator.writeStartObject();
            val.marshall(context.protocolHandler());
            jsonGenerator.writeEndObject();
        }
    };
    public static final JsonMarshaller<List> LIST = new BaseJsonMarshaller<List>(){

        @Override
        public void marshall(List list, StructuredJsonGenerator jsonGenerator, JsonMarshallerContext context) {
            jsonGenerator.writeStartArray();
            for (Object listValue : list) {
                context.marshall(MarshallLocation.PAYLOAD, listValue);
            }
            jsonGenerator.writeEndArray();
        }

        @Override
        protected boolean shouldEmit(List list) {
            return !list.isEmpty() || !(list instanceof SdkInternalList) || !((SdkInternalList)list).isAutoConstruct();
        }
    };
    public static final JsonMarshaller<Map> MAP = new BaseJsonMarshaller<Map>(){

        @Override
        public void marshall(Map map, StructuredJsonGenerator jsonGenerator, JsonMarshallerContext context) {
            jsonGenerator.writeStartObject();
            for (Map.Entry entry : map.entrySet()) {
                if (entry.getValue() == null) continue;
                Object value = entry.getValue();
                jsonGenerator.writeFieldName((String)entry.getKey());
                context.marshall(MarshallLocation.PAYLOAD, value);
            }
            jsonGenerator.writeEndObject();
        }

        @Override
        protected boolean shouldEmit(Map map) {
            return !map.isEmpty() || !(map instanceof SdkInternalMap) || !((SdkInternalMap)map).isAutoConstruct();
        }
    };

    private static abstract class BaseJsonMarshaller<T>
    implements JsonMarshaller<T> {
        private BaseJsonMarshaller() {
        }

        @Override
        public final void marshall(T val, JsonMarshallerContext context, String paramName) {
            if (!this.shouldEmit(val)) {
                return;
            }
            if (paramName != null) {
                context.jsonGenerator().writeFieldName(paramName);
            }
            this.marshall(val, context.jsonGenerator(), context);
        }

        public abstract void marshall(T var1, StructuredJsonGenerator var2, JsonMarshallerContext var3);

        protected boolean shouldEmit(T val) {
            return true;
        }
    }
}

