/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.metrics;

import java.util.concurrent.TimeUnit;
import software.amazon.awssdk.metrics.AwsSdkMetrics;
import software.amazon.awssdk.metrics.ByteThroughputProvider;
import software.amazon.awssdk.metrics.ServiceMetricCollector;
import software.amazon.awssdk.metrics.ThroughputMetricType;

class ByteThroughputHelper
extends ByteThroughputProvider {
    private static final int REPORT_INTERVAL_SECS = 10;

    ByteThroughputHelper(ThroughputMetricType type) {
        super(type);
    }

    long startTiming() {
        if (TimeUnit.NANOSECONDS.toSeconds(this.getDurationNano()) > 10L) {
            this.reportMetrics();
        }
        return System.nanoTime();
    }

    void reportMetrics() {
        if (this.getByteCount() > 0) {
            Object col = AwsSdkMetrics.getServiceMetricCollector();
            ((ServiceMetricCollector)col).collectByteThroughput(this);
            this.reset();
        }
    }

    @Override
    public void increment(int bytesDelta, long startTimeNano) {
        super.increment(bytesDelta, startTimeNano);
    }
}

