/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.internal.region;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.internal.region.PartitionRegionMetadata;
import software.amazon.awssdk.internal.region.RegionMetadataProvider;
import software.amazon.awssdk.internal.region.model.Partition;
import software.amazon.awssdk.regions.PartitionServiceMetadata;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.regions.RegionMetadata;
import software.amazon.awssdk.regions.ServiceMetadata;
import software.amazon.awssdk.regions.ServiceMetadataProvider;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public final class PartitionMetadataProvider
implements RegionMetadataProvider,
ServiceMetadataProvider {
    private static final String DEFAULT_PARTITION = "aws";
    private final Map<String, Partition> partitionMap = new HashMap<String, Partition>();
    private final Map<String, RegionMetadata> regionMetadata = new ConcurrentHashMap<String, RegionMetadata>();
    private final Map<String, ServiceMetadata> serviceMetadata = new ConcurrentHashMap<String, ServiceMetadata>();

    public PartitionMetadataProvider(List<Partition> partitions) {
        Validate.notNull(partitions, (String)"partitions", (Object[])new Object[0]);
        partitions.forEach(p -> this.partitionMap.put(p.getPartition(), (Partition)p));
    }

    @Override
    public RegionMetadata getRegionMetadata(Region region) {
        if (region == null) {
            return null;
        }
        RegionMetadata regionFromCache = this.getRegionFromCache(region);
        return regionFromCache != null ? regionFromCache : this.createNewRegion(region);
    }

    @Override
    public ServiceMetadata getServiceMetadata(String serviceEndpointPrefix) {
        if (serviceEndpointPrefix == null) {
            return null;
        }
        ServiceMetadata serviceMetadataFromCache = this.getServiceMetadataFromCache(serviceEndpointPrefix);
        return serviceMetadataFromCache != null ? serviceMetadataFromCache : this.createNewServiceMetadata(serviceEndpointPrefix);
    }

    private RegionMetadata createNewRegion(Region region) {
        return this.partitionMap.values().stream().filter(p -> p.hasRegion(region.value())).map(p -> this.cacheRegion(region, (Partition)p)).findFirst().orElseGet(() -> this.cacheRegion(region, this.partitionMap.get(DEFAULT_PARTITION)));
    }

    private RegionMetadata getRegionFromCache(Region region) {
        return this.regionMetadata.get(region.value());
    }

    private RegionMetadata cacheRegion(Region region, Partition p) {
        return this.regionMetadata.computeIfAbsent(region.value(), ignored -> new PartitionRegionMetadata(region.value(), p));
    }

    private ServiceMetadata createNewServiceMetadata(String serviceEndpointPrefix) {
        return this.serviceMetadata.computeIfAbsent(serviceEndpointPrefix, ignored -> new PartitionServiceMetadata(serviceEndpointPrefix, this.partitionMap));
    }

    private ServiceMetadata getServiceMetadataFromCache(String serviceEndpointPrefix) {
        return this.serviceMetadata.get(serviceEndpointPrefix);
    }
}

