/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.internal.net;

import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URI;
import software.amazon.awssdk.annotation.SdkInternalApi;

@SdkInternalApi
public class ConnectionUtils {
    private static volatile ConnectionUtils instance;

    private ConnectionUtils() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ConnectionUtils getInstance() {
        if (instance != null) return instance;
        Class<ConnectionUtils> clazz = ConnectionUtils.class;
        synchronized (ConnectionUtils.class) {
            if (instance != null) return instance;
            instance = new ConnectionUtils();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public HttpURLConnection connectToEndpoint(URI endpoint) throws IOException {
        HttpURLConnection connection = (HttpURLConnection)endpoint.toURL().openConnection();
        connection.setConnectTimeout(2000);
        connection.setReadTimeout(5000);
        connection.setRequestMethod("GET");
        connection.setDoOutput(true);
        connection.connect();
        return connection;
    }
}

