/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.internal.http.timers.client;

import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.http.Abortable;
import software.amazon.awssdk.internal.http.timers.client.ClientExecutionAbortTask;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class ClientExecutionAbortTaskImpl
implements ClientExecutionAbortTask {
    private final Thread thread;
    private volatile boolean hasTaskExecuted;
    private volatile Abortable currentRequest;

    public ClientExecutionAbortTaskImpl(Thread thread) {
        this.thread = thread;
    }

    @Override
    public void run() {
        this.hasTaskExecuted = true;
        if (!this.thread.isInterrupted()) {
            this.thread.interrupt();
        }
        if (this.currentRequest != null) {
            this.currentRequest.abort();
        }
    }

    @Override
    public void setCurrentHttpRequest(Abortable newRequest) {
        this.currentRequest = (Abortable)Validate.notNull((Object)newRequest, (String)"Abortable caonnot be null", (Object[])new Object[0]);
    }

    @Override
    public boolean hasClientExecutionAborted() {
        return this.hasTaskExecuted;
    }

    @Override
    public boolean isEnabled() {
        return true;
    }
}

