/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.internal.http.response;

import com.fasterxml.jackson.core.JsonFactory;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import software.amazon.awssdk.AmazonServiceException;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.handlers.AwsHandlerKeys;
import software.amazon.awssdk.http.HttpResponse;
import software.amazon.awssdk.http.HttpResponseHandler;
import software.amazon.awssdk.internal.http.ErrorCodeParser;
import software.amazon.awssdk.protocol.json.JsonContent;
import software.amazon.awssdk.runtime.http.JsonErrorMessageParser;
import software.amazon.awssdk.runtime.transform.JsonErrorUnmarshaller;

@SdkInternalApi
public class JsonErrorResponseHandler
implements HttpResponseHandler<AmazonServiceException> {
    private static final Log LOG = LogFactory.getLog(JsonErrorResponseHandler.class);
    private final List<JsonErrorUnmarshaller> unmarshallers;
    private final ErrorCodeParser errorCodeParser;
    private final JsonErrorMessageParser errorMessageParser;
    private final JsonFactory jsonFactory;

    public JsonErrorResponseHandler(List<JsonErrorUnmarshaller> errorUnmarshallers, ErrorCodeParser errorCodeParser, JsonErrorMessageParser errorMessageParser, JsonFactory jsonFactory) {
        this.unmarshallers = errorUnmarshallers;
        this.errorCodeParser = errorCodeParser;
        this.errorMessageParser = errorMessageParser;
        this.jsonFactory = jsonFactory;
    }

    @Override
    public boolean needsConnectionLeftOpen() {
        return false;
    }

    @Override
    public AmazonServiceException handle(HttpResponse response) throws Exception {
        JsonContent jsonContent = JsonContent.createJsonContent(response, this.jsonFactory);
        String errorCode = this.errorCodeParser.parseErrorCode(response, jsonContent);
        AmazonServiceException ase = this.createException(errorCode, jsonContent);
        if (ase.getErrorMessage() == null) {
            ase.setErrorMessage(this.errorMessageParser.parseErrorMessage(response, jsonContent.getJsonNode()));
        }
        ase.setErrorCode(errorCode);
        ase.setServiceName((String)response.getRequest().handlerContext(AwsHandlerKeys.SERVICE_NAME));
        ase.setStatusCode(response.getStatusCode());
        ase.setErrorType(this.getErrorTypeFromStatusCode(response.getStatusCode()));
        ase.setRawResponse(jsonContent.getRawContent());
        String requestId = this.getRequestIdFromHeaders(response.getHeaders());
        if (requestId != null) {
            ase.setRequestId(requestId);
        }
        ase.setHttpHeaders(response.getHeaders());
        return ase;
    }

    private AmazonServiceException createException(String errorCode, JsonContent jsonContent) {
        AmazonServiceException ase = this.unmarshallException(errorCode, jsonContent);
        if (ase == null) {
            ase = new AmazonServiceException("Unable to unmarshall exception response with the unmarshallers provided");
        }
        return ase;
    }

    private AmazonServiceException unmarshallException(String errorCode, JsonContent jsonContent) {
        for (JsonErrorUnmarshaller unmarshaller : this.unmarshallers) {
            if (!unmarshaller.matchErrorCode(errorCode)) continue;
            try {
                return unmarshaller.unmarshall(jsonContent.getJsonNode());
            }
            catch (Exception e) {
                LOG.info((Object)"Unable to unmarshall exception content", (Throwable)e);
                return null;
            }
        }
        return null;
    }

    private AmazonServiceException.ErrorType getErrorTypeFromStatusCode(int statusCode) {
        return statusCode < 500 ? AmazonServiceException.ErrorType.Client : AmazonServiceException.ErrorType.Service;
    }

    private String getRequestIdFromHeaders(Map<String, String> headers) {
        for (Map.Entry<String, String> headerEntry : headers.entrySet()) {
            if (!headerEntry.getKey().equalsIgnoreCase("x-amzn-RequestId")) continue;
            return headerEntry.getValue();
        }
        return null;
    }
}

