/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.internal.http.response;

import software.amazon.awssdk.AmazonServiceException;
import software.amazon.awssdk.SdkBaseException;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.handlers.AwsHandlerKeys;
import software.amazon.awssdk.http.HttpResponse;
import software.amazon.awssdk.http.HttpResponseHandler;
import software.amazon.awssdk.metrics.spi.AwsRequestMetrics;
import software.amazon.awssdk.metrics.spi.MetricType;

@SdkInternalApi
public class AwsErrorResponseHandler
implements HttpResponseHandler<SdkBaseException> {
    private final HttpResponseHandler<? extends SdkBaseException> delegate;
    private final AwsRequestMetrics awsRequestMetrics;

    public AwsErrorResponseHandler(HttpResponseHandler<? extends SdkBaseException> errorResponseHandler, AwsRequestMetrics awsRequestMetrics) {
        this.delegate = errorResponseHandler;
        this.awsRequestMetrics = awsRequestMetrics;
    }

    @Override
    public AmazonServiceException handle(HttpResponse response) throws Exception {
        AmazonServiceException ase = (AmazonServiceException)this.handleAse(response);
        ase.setStatusCode(response.getStatusCode());
        ase.setServiceName((String)response.getRequest().handlerContext(AwsHandlerKeys.SERVICE_NAME));
        this.awsRequestMetrics.addPropertyWith((MetricType)AwsRequestMetrics.Field.AWSRequestID, (Object)ase.getRequestId()).addPropertyWith((MetricType)AwsRequestMetrics.Field.AWSErrorCode, (Object)ase.getErrorCode()).addPropertyWith((MetricType)AwsRequestMetrics.Field.StatusCode, (Object)ase.getStatusCode());
        return ase;
    }

    private SdkBaseException handleAse(HttpResponse response) throws Exception {
        int statusCode = response.getStatusCode();
        try {
            return this.delegate.handle(response);
        }
        catch (InterruptedException e) {
            throw e;
        }
        catch (Exception e) {
            if (statusCode == 413) {
                AmazonServiceException exception = new AmazonServiceException("Request entity too large");
                exception.setStatusCode(statusCode);
                exception.setErrorType(AmazonServiceException.ErrorType.Client);
                exception.setErrorCode("Request entity too large");
                return exception;
            }
            if (statusCode >= 500 && statusCode < 600) {
                AmazonServiceException exception = new AmazonServiceException(response.getStatusText());
                exception.setStatusCode(statusCode);
                exception.setErrorType(AmazonServiceException.ErrorType.Service);
                exception.setErrorCode(response.getStatusText());
                return exception;
            }
            throw e;
        }
    }

    @Override
    public boolean needsConnectionLeftOpen() {
        return this.delegate.needsConnectionLeftOpen();
    }
}

